/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.model.service.internal;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentTemplate;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ITag;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.elexis.omnivore.model.TransientCategory;
import ch.elexis.omnivore.model.util.CategoryUtil;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"storeid=ch.elexis.data.store.omnivore"})
public class OmnivoreDocumentStore
implements IDocumentStore {
    private static final String STORE_ID = "ch.elexis.data.store.omnivore";
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference(target="(service.model.name=ch.elexis.omnivore.data.model)")
    private IModelService modelService;

    public String getId() {
        return STORE_ID;
    }

    public String getName() {
        return "Omnivore";
    }

    public List<IDocument> getDocuments(String patientId, String authorId, ICategory category, List<ITag> tag) {
        Optional patient = this.coreModelService.load(patientId, IPatient.class);
        if (patient.isPresent()) {
            IQuery query = this.modelService.getQuery(IDocumentHandle.class);
            query.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT__PATIENT, IQuery.COMPARATOR.EQUALS, patient.get());
            if (authorId != null) {
                Optional author = this.coreModelService.load(authorId, IContact.class);
                author.ifPresent(a -> query.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT__AUTHOR, IQuery.COMPARATOR.EQUALS, a));
            }
            if (category != null && category.getName() != null) {
                query.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT__CATEGORY, IQuery.COMPARATOR.EQUALS, (Object)category.getName());
            }
            List results = query.execute();
            results.parallelStream().forEach(d -> d.setStoreId(STORE_ID));
            return results;
        }
        return Collections.emptyList();
    }

    public List<ICategory> getCategories() {
        List<String> categoriesNames = CategoryUtil.getCategoriesNames();
        return categoriesNames.stream().map(o -> new TransientCategory((String)o)).collect(Collectors.toList());
    }

    public Optional<IDocument> loadDocument(String id) {
        return this.modelService.load(id, IDocumentHandle.class);
    }

    public void removeDocument(IDocument document) {
        Optional existing = this.modelService.load(document.getId(), IDocumentHandle.class);
        existing.ifPresent(d -> this.modelService.delete((Deleteable)d));
    }

    public IDocument saveDocument(IDocument document) throws ElexisException {
        return this.save(document, null);
    }

    public IDocument saveDocument(IDocument document, InputStream content) throws ElexisException {
        return this.save(document, content);
    }

    private IDocument save(IDocument document, InputStream content) throws ElexisException {
        try {
            if (content != null) {
                document.setContent(content);
            }
            this.modelService.save((Identifiable)document);
            return document;
        }
        catch (PersistenceException e) {
            throw new ElexisException("cannot save", (Throwable)e);
        }
    }

    public Optional<InputStream> loadContent(IDocument document) {
        return Optional.ofNullable(document.getContent());
    }

    public IDocument createDocument(String patientId, String title, String categoryName) {
        IDocumentHandle handle = (IDocumentHandle)this.modelService.create(IDocumentHandle.class);
        handle.setStoreId(STORE_ID);
        handle.setTitle(title);
        handle.setPatient(this.coreModelService.load(patientId, IPatient.class).orElse(null));
        TransientCategory iCategory = categoryName != null ? new TransientCategory(categoryName) : this.getCategoryDefault();
        handle.setCategory(iCategory);
        return handle;
    }

    public ICategory getCategoryDefault() {
        return new TransientCategory("default");
    }

    public Optional<Object> getPersistenceObject(IDocument iDocument) {
        return Optional.empty();
    }

    public ICategory createCategory(String name) {
        if (name != null && CategoryUtil.findCategoriesByName(name).isEmpty()) {
            CategoryUtil.addCategory(name);
        }
        return new TransientCategory(name);
    }

    public void removeCategory(IDocument iDocument, String newCategory) throws IllegalStateException {
        if (iDocument.getId() != null && iDocument.getCategory() != null) {
            ICategory oldCategory = iDocument.getCategory();
            List<IDocumentHandle> existing = CategoryUtil.getDocumentsWithCategoryByName(oldCategory.getName());
            if (existing.isEmpty() || existing.size() == 1 && existing.get(0).getId().equals(iDocument.getId())) {
                CategoryUtil.removeCategory(oldCategory.getName(), newCategory);
            } else {
                throw new IllegalStateException("at least one document to category reference exists with id: " + existing.get(0).getId());
            }
        }
    }

    public void removeCategory(ICategory category, ICategory newCategory) {
        ICategory targetCategory = newCategory != null ? newCategory : this.getCategoryDefault();
        CategoryUtil.removeCategory(category.getName(), targetCategory.getName());
    }

    public void renameCategory(ICategory category, String newCategory) throws IllegalStateException {
        CategoryUtil.renameCategory(category.getName(), newCategory);
    }

    public List<IDocumentTemplate> getDocumentTemplates(boolean includeSystem) {
        return Collections.emptyList();
    }
}

