/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.data.service.internal;

import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.omnivore.model.IDocumentHandle;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class LocalDocumentServiceHolder {
    private static Optional<ILocalDocumentService> localDocumentService;

    @Reference
    public void bind(ILocalDocumentService service) {
        localDocumentService = Optional.ofNullable(service);
        service.registerSaveHandler(IDocumentHandle.class, new ILocalDocumentService.ISaveHandler(){

            public boolean save(Object documentSource, ILocalDocumentService service) {
                IDocumentHandle docHandle = (IDocumentHandle)documentSource;
                Optional content = service.getContent((Object)docHandle);
                if (content.isPresent()) {
                    try {
                        docHandle.setContent((InputStream)content.get());
                        return true;
                    }
                    finally {
                        try {
                            ((InputStream)content.get()).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return false;
            }
        });
        service.registerLoadHandler(IDocumentHandle.class, new ILocalDocumentService.ILoadHandler(){

            public InputStream load(Object documentSource) {
                IDocumentHandle docHandle = (IDocumentHandle)documentSource;
                return docHandle.getContent();
            }
        });
    }

    public void unbind(ILocalDocumentService service) {
        localDocumentService = Optional.empty();
    }

    public static Optional<ILocalDocumentService> getService() {
        return localDocumentService;
    }
}

