/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.data;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.ui.dialogs.ResultDialog;
import ch.elexis.core.ui.services.EncounterServiceHolder;
import ch.rgw.tools.Result;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class AutomaticBilling {
    private static Executor executor = Executors.newSingleThreadExecutor();
    private IPatient patient;
    private IDocument docHandle;

    public static boolean isEnabled() {
        String blockId = ConfigServiceHolder.get().getLocal("ch.elexis.omnivore/automatic_billing_block", "");
        return ConfigServiceHolder.get().getLocal("ch.elexis.omnivore/automatic_billing", false) && !blockId.isEmpty();
    }

    public AutomaticBilling(IDocument docHandle) {
        this.patient = docHandle.getPatient();
        this.docHandle = docHandle;
    }

    public void bill() {
        if (AutomaticBilling.isEnabled() && this.docHandle != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ICodeElementBlock block;
                        String blockId;
                        IEncounter encounter = AutomaticBilling.this.getEncounter();
                        if (encounter != null && StringUtils.isNotBlank((CharSequence)(blockId = ConfigServiceHolder.get().getLocal("ch.elexis.omnivore/automatic_billing_block", ""))) && (block = (ICodeElementBlock)CoreModelServiceHolder.get().load(blockId, ICodeElementBlock.class).orElse(null)) != null) {
                            if (encounter != null && BillingServiceHolder.get().isEditable(encounter).isOK()) {
                                AutomaticBilling.this.addBlockToEncounter(block, encounter);
                            } else {
                                LoggerFactory.getLogger(this.getClass()).warn(String.format("Could not add block [%s] for document of patient [%s] because no valid kons found.", block.getCode(), AutomaticBilling.this.patient.getLabel()));
                            }
                        }
                    }
                    catch (Exception e) {
                        MessageEvent.fireError((String)"Error", (String)"Es ist ein Fehler bei der automatischen Verrechnung aufgetreten.");
                        LoggerFactory.getLogger(this.getClass()).error("Error billing block", (Throwable)e);
                    }
                }
            });
        }
    }

    private void addBlockToEncounter(ICodeElementBlock block, IEncounter encounter) {
        List elements = block.getElements(encounter);
        StringJoiner notOkResults = new StringJoiner("\n");
        for (ICodeElement element : elements) {
            Result result;
            if (!(element instanceof IBillable) || (result = BillingServiceHolder.get().bill((IBillable)element, encounter, 1.0)).isOK()) continue;
            String message = this.patient.getLabel() + "\nDokument import Verrechnung von [" + element.getCode() + "]\n\n" + ResultDialog.getResultMessage((Result)result);
            if (notOkResults.toString().contains(message)) continue;
            notOkResults.add(message);
        }
        if (!notOkResults.toString().isEmpty()) {
            MessageEvent.fireWarninig((String)Messages.VerrechnungsDisplay_imvalidBilling, (String)notOkResults.toString());
        }
    }

    private IEncounter getEncounter() {
        Optional<IEncounter> encounter = EncounterServiceHolder.get().getLatestEncounter(this.patient);
        if (!encounter.isPresent() || !EncounterServiceHolder.get().isEditable((IEncounter)encounter.get())) {
            encounter = this.createEncounter();
        }
        return encounter.orElse(null);
    }

    private Optional<IEncounter> createEncounter() {
        Optional lastEncounter = EncounterServiceHolder.get().getLatestEncounter(this.patient);
        ICoverage coverage = null;
        if (lastEncounter.isPresent()) {
            coverage = ((IEncounter)lastEncounter.get()).getCoverage();
        }
        if (coverage == null || !coverage.isOpen()) {
            List<ICoverage> openFall = this.getOpenFall();
            coverage = openFall.isEmpty() ? new ICoverageBuilder(CoreModelServiceHolder.get(), this.patient, CoverageServiceHolder.get().getDefaultCoverageLabel(), CoverageServiceHolder.get().getDefaultCoverageReason(), CoverageServiceHolder.get().getDefaultCoverageLaw()).buildAndSave() : openFall.get(0);
        }
        if (coverage != null) {
            return Optional.of((IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), coverage, (IMandator)ContextServiceHolder.get().getActiveMandator().orElse(null)).buildAndSave());
        }
        return Optional.empty();
    }

    private List<ICoverage> getOpenFall() {
        ArrayList<ICoverage> ret = new ArrayList<ICoverage>();
        List coverages = this.patient.getCoverages();
        for (ICoverage f : coverages) {
            if (!f.isOpen()) continue;
            ret.add(f);
        }
        ret.sort(new Comparator<ICoverage>(){

            @Override
            public int compare(ICoverage o1, ICoverage o2) {
                if (o1.getDateFrom() != null && o2.getDateFrom() != null) {
                    return o1.getDateFrom().compareTo(o2.getDateFrom());
                }
                return Long.compare(o1.getLastupdate(), o2.getLastupdate());
            }
        });
        return ret;
    }
}

