/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.data.model;

import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.Patient;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class OpaqueDocumentAdapter
implements IOpaqueDocument {
    private IDocumentHandle documentHandle;

    public OpaqueDocumentAdapter(IDocumentHandle documentHandle) {
        this.documentHandle = documentHandle;
    }

    public String getTitle() {
        return this.documentHandle.getTitle();
    }

    public String getMimeType() {
        return this.documentHandle.getMimeType();
    }

    public InputStream getContentsAsStream() throws ElexisException {
        return this.documentHandle.getContent();
    }

    public byte[] getContentsAsBytes() throws ElexisException {
        try {
            return IOUtils.toByteArray((InputStream)this.documentHandle.getContent());
        }
        catch (IOException e) {
            throw new ElexisException("Error getting content", (Throwable)e);
        }
    }

    public String getKeywords() {
        return this.documentHandle.getKeywords();
    }

    public String getCategory() {
        return this.documentHandle.getCategory().getName();
    }

    public String getCreationDate() {
        return new TimeTool(this.documentHandle.getCreated()).toString(4);
    }

    public Patient getPatient() {
        return Patient.load((String)this.documentHandle.getPatient().getId());
    }

    public String getGUID() {
        return this.documentHandle.getId();
    }
}

