/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.notes;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.text.ETFTextPlugin;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.notes.AddLinkDialog;
import ch.elexis.notes.Messages;
import ch.elexis.notes.Note;
import ch.rgw.tools.ExHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class NotesDetail
extends Composite {
    private ETFTextPlugin etf;
    List lRefs;
    Text tKeywords;
    ScrolledForm fNote;
    ScrolledForm fRefs;
    FormToolkit tk = UiDesk.getToolkit();
    private IAction newRefAction;
    private IAction delRefAction;
    Note actNote;

    NotesDetail(Composite parent) {
        super(parent, 0);
        this.etf = new ETFTextPlugin();
        this.setLayout((Layout)new GridLayout());
        SashForm sash = new SashForm((Composite)this, 512);
        sash.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.fNote = this.tk.createScrolledForm((Composite)sash);
        this.fNote.getBody().setLayout((Layout)new GridLayout());
        this.etf.createContainer(this.fNote.getBody(), (ITextPlugin.ICallback)new SaveCallback()).setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.etf.setSaveOnFocusLost(true);
        this.tKeywords = this.tk.createText(this.fNote.getBody(), "");
        this.tKeywords.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tKeywords.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (NotesDetail.this.actNote != null) {
                    NotesDetail.this.actNote.setKeywords(NotesDetail.this.tKeywords.getText());
                }
                super.focusLost(e);
            }
        });
        this.fRefs = this.tk.createScrolledForm((Composite)sash);
        this.fRefs.getBody().setLayout((Layout)new GridLayout());
        this.lRefs = new List(this.fRefs.getBody(), 4);
        this.lRefs.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                String[] sel = NotesDetail.this.lRefs.getSelection();
                if (sel.length > 0) {
                    NotesDetail.this.execute(sel[0]);
                }
            }
        });
        this.lRefs.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.fRefs.setText(Messages.NotesDetail_xrefs);
        this.makeActions();
        this.fRefs.getToolBarManager().add(this.newRefAction);
        this.fRefs.getToolBarManager().add(this.delRefAction);
        this.fRefs.updateToolBar();
        this.tk.adapt((Control)this.lRefs, true, true);
        sash.setWeights(new int[]{80, 20});
    }

    public void setNote(Note note) {
        this.actNote = note;
        this.fNote.setText(note.get("Title"));
        this.etf.loadFromByteArray(note.getContent(), false);
        this.tKeywords.setText(note.getKeywords());
        this.lRefs.removeAll();
        for (String s : note.getRefs()) {
            this.lRefs.add(s);
        }
    }

    public void execute(String filename) {
        try {
            Program proggie;
            int r = filename.lastIndexOf(46);
            String ext = "";
            if (r != -1) {
                ext = filename.substring(r + 1);
            }
            if ((proggie = Program.findProgram((String)ext)) != null) {
                proggie.execute(filename);
            } else if (!Program.launch((String)filename)) {
                Runtime.getRuntime().exec(filename);
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            SWTHelper.showError((String)Messages.NotesDetail_couldNotLaunch, (String)ex.getMessage());
        }
    }

    private void makeActions() {
        this.newRefAction = new Action(Messages.NotesDetail_newActionCaption){
            {
                this.setToolTipText(Messages.NotesDetail_newActionToolTip);
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            }

            public void run() {
                if (new AddLinkDialog(NotesDetail.this.getShell(), NotesDetail.this.actNote).open() == 0) {
                    NotesDetail.this.setNote(NotesDetail.this.actNote);
                }
            }
        };
        this.delRefAction = new Action(Messages.NotesDetail_deleteActionCaption){
            {
                this.setToolTipText(Messages.NotesDetail_deleteActionToolTip);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            }

            public void run() {
                String actRef = NotesDetail.this.lRefs.getSelection()[0];
                if (SWTHelper.askYesNo((String)Messages.NotesDetail_deleteConfirmCaption, (String)Messages.NotesDetail_deleteConfirmMessage)) {
                    NotesDetail.this.actNote.removeRef(actRef);
                    NotesDetail.this.setNote(NotesDetail.this.actNote);
                }
            }
        };
    }

    class SaveCallback
    implements ITextPlugin.ICallback {
        SaveCallback() {
        }

        public void save() {
            byte[] cnt = NotesDetail.this.etf.storeToByteArray();
            NotesDetail.this.actNote.setContent(cnt);
        }

        public boolean saveAs() {
            return false;
        }
    }
}

