/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.notes;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.notes.Messages;
import ch.elexis.notes.Note;
import ch.elexis.notes.NotesDetail;
import ch.elexis.notes.NotesList;
import ch.rgw.compress.CompEx;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import jakarta.inject.Inject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class NotesView
extends ViewPart
implements IRefreshable {
    static final String ID = "ch.elexis.notes.view";
    ScrolledForm fMaster;
    NotesList master;
    NotesDetail detail;
    boolean hasScanner = false;
    private IAction newCategoryAction;
    private IAction newNoteAction;
    private IAction delNoteAction;
    private IAction scanAction;
    FormToolkit tk = UiDesk.getToolkit();
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    public void createPartControl(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        this.fMaster = this.tk.createScrolledForm((Composite)sash);
        this.fMaster.getBody().setLayout((Layout)new GridLayout());
        this.master = new NotesList(this.fMaster.getBody());
        this.master.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.detail = new NotesDetail((Composite)sash);
        this.makeActions();
        this.fMaster.setText(Messages.NotesView_categories);
        if (this.hasScanner) {
            this.fMaster.getToolBarManager().add(this.scanAction);
            this.fMaster.getToolBarManager().add((IContributionItem)new Separator());
        }
        this.fMaster.getToolBarManager().add(this.newCategoryAction);
        this.fMaster.getToolBarManager().add(this.newNoteAction);
        this.fMaster.getToolBarManager().add(this.delNoteAction);
        this.fMaster.getToolBarManager().add((IContributionItem)new Separator());
        this.newNoteAction.setEnabled(false);
        this.detail.setEnabled(false);
        this.fMaster.updateToolBar();
        sash.setWeights(new int[]{3, 7});
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
    }

    public void setFocus() {
    }

    private void makeActions() {
        this.newCategoryAction = new Action(Messages.NotesView_newCategory){
            {
                this.setToolTipText(Messages.NotesView_createMainCategoryTootltip);
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            }

            public void run() {
                InputDialog id = new InputDialog(NotesView.this.getViewSite().getShell(), Messages.NotesView_createMainCategoryDlgTitle, Messages.NotesView_createMainCategoryDlgMessage, "", null);
                if (id.open() == 0) {
                    new Note(null, id.getValue(), "");
                    NotesView.this.master.tv.refresh();
                }
            }
        };
        this.newNoteAction = new Action(Messages.NotesView_newNoteCaption){
            {
                this.setToolTipText(Messages.NotesView_newNoteTooltip);
                this.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
            }

            public void run() {
                InputDialog id;
                Note act = (Note)ElexisEventDispatcher.getSelected(Note.class);
                if (act != null && (id = new InputDialog(NotesView.this.getViewSite().getShell(), Messages.NotesView_newNoteDlgTitle, Messages.NotesView_newNoteDlgMessage, "", null)).open() == 0) {
                    new Note(act, id.getValue(), "");
                    NotesView.this.master.tv.refresh();
                }
            }
        };
        this.delNoteAction = new Action(Messages.NotesView_deleteActionCaption){
            {
                this.setToolTipText(Messages.NotesView_deleteActionTooltip);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            }

            public void run() {
                Note act = (Note)ElexisEventDispatcher.getSelected(Note.class);
                if (act != null && SWTHelper.askYesNo((String)Messages.NotesView_deleteConfirmDlgTitle, (String)Messages.NotesView_deleteConfirmDlgMessage)) {
                    act.delete();
                    NotesView.this.master.tv.refresh();
                }
            }
        };
        if (Extensions.isServiceAvailable((String)"ScanToPDFService")) {
            this.hasScanner = true;
            this.scanAction = new Action(Messages.NotesView_scabCaption){
                {
                    this.setToolTipText(Messages.NotesView_scanTooltip);
                    ImageDescriptor imgScanner = AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.notes", (String)("icons" + File.separator + "scanner.ico"));
                    this.setImageDescriptor(imgScanner);
                }

                public void run() {
                    try {
                        Result res;
                        Object scanner = Extensions.findBestService((String)"ScanToPDFService");
                        if (scanner != null && (res = (Result)Extensions.executeService((Object)scanner, (String)"acquire", (Class[])new Class[0], (Object[])new Object[0])).isOK()) {
                            Note act = (Note)ElexisEventDispatcher.getSelected(Note.class);
                            byte[] pdf = (byte[])res.get();
                            InputDialog id = new InputDialog(NotesView.this.getViewSite().getShell(), Messages.NotesView_importDocuDlgTitle, Messages.NotesView_importDocDlgMessage, "", null);
                            if (id.open() == 0) {
                                String name = id.getValue();
                                String basedir = CoreHub.localCfg.get("notes/basedir", null);
                                if (basedir == null) {
                                    SWTHelper.alert((String)Messages.NotesView_badBaseDirectoryTitle, (String)Messages.NotesView_badBaseDirectoryMessage);
                                    return;
                                }
                                File file = new File(basedir, name.replaceAll("\\s", "_") + ".pdf");
                                if (!file.createNewFile()) {
                                    SWTHelper.alert((String)Messages.NotesView_importErrorTitle, (String)("Kann Datei " + file.getAbsolutePath() + " nicht schreiben"));
                                    return;
                                }
                                FileOutputStream fout = new FileOutputStream(file);
                                BufferedOutputStream bout = new BufferedOutputStream(fout);
                                bout.write(pdf);
                                bout.close();
                                Samdas samdas = new Samdas(name);
                                Samdas.Record record = samdas.getRecord();
                                Samdas.XRef xref = new Samdas.XRef("ch.elexis.text.ExternalLink", file.getAbsolutePath(), 0, name.length());
                                record.add((Samdas.Range)xref);
                                XMLOutputter xo = new XMLOutputter(Format.getRawFormat());
                                String cnt = xo.outputString(samdas.getDocument());
                                byte[] nb = CompEx.Compress((byte[])cnt.getBytes("utf-8"), (int)-1610612736);
                                new Note(act, name, nb, "text/xml");
                                NotesView.this.master.tv.refresh();
                            }
                        }
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        SWTHelper.showError((String)Messages.NotesView_importErrorDlgTitle, (String)ex.getMessage());
                    }
                }
            };
        }
    }

    public void refresh() {
        this.activeNote(ContextServiceHolder.get().getTyped(Note.class).orElse(null));
    }

    @Inject
    void activeNote(@Optional Note note) {
        CoreUiUtil.runAsyncIfActive(() -> {
            if (note != null) {
                this.detail.setEnabled(true);
                this.detail.setNote(note);
                if (this.newNoteAction != null) {
                    this.newNoteAction.setEnabled(true);
                }
            } else if (this.newNoteAction != null) {
                this.newNoteAction.setEnabled(false);
            }
        }, (Object)this.fMaster);
    }
}

