/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.notes;

import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class Note
extends PersistentObject {
    public static final String FLD_MIMETYPE = "mimetype";
    public static final String FLD_KEYWORDS = "keywords";
    public static final String FLD_REFS = "refs";
    public static final String FLD_CONTENTS = "Contents";
    public static final String FLD_TITLE = "Title";
    private static final String FLD_PARENT = "Parent";
    private static final String TABLENAME = "CH_ELEXIS_NOTES";

    static {
        Note.addMapping((String)TABLENAME, (String[])new String[]{FLD_PARENT, FLD_TITLE, FLD_CONTENTS, "Datum=S:D:Date", FLD_REFS, FLD_KEYWORDS, FLD_MIMETYPE});
    }

    public Note(Note parent, String title, String text) {
        this.create(null);
        this.set(new String[]{FLD_TITLE, "Datum", FLD_MIMETYPE}, new String[]{title, new TimeTool().toString(4), "text/plain"});
        try {
            this.setContent(text.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            ExHandler.handle((Throwable)e);
        }
        if (parent != null) {
            this.set(FLD_PARENT, parent.getId());
        }
    }

    public Note(Note parent, String title, byte[] contents, String mimetype) {
        this.create(null);
        this.set(new String[]{FLD_TITLE, "Datum", FLD_MIMETYPE}, new String[]{title, new TimeTool().toString(4), mimetype});
        this.setContent(contents);
        if (parent != null) {
            this.set(FLD_PARENT, parent.getId());
        }
    }

    public Note getParent() {
        String pid = this.get(FLD_PARENT);
        if (pid == null) {
            return null;
        }
        Note p = Note.load(pid);
        return p;
    }

    public List<Note> getChildren() {
        Query qbe = new Query(Note.class);
        qbe.add(FLD_PARENT, "=", this.getId());
        return qbe.execute();
    }

    public void setContent(byte[] cnt) {
        this.setBinary(FLD_CONTENTS, cnt);
        this.set("Datum", new TimeTool().toString(4));
    }

    public byte[] getContent() {
        return this.getBinary(FLD_CONTENTS);
    }

    public String getKeywords() {
        return Note.checkNull((Object)this.get(FLD_KEYWORDS));
    }

    public void setKeywords(String kw) {
        this.set(FLD_KEYWORDS, StringTool.limitLength((String)kw.toLowerCase(), (int)250));
    }

    public List<String> getRefs() {
        String all = this.get(FLD_REFS);
        if (StringTool.isNothing((Object)all)) {
            return new ArrayList<String>();
        }
        return StringTool.splitAL((String)all, (String)",");
    }

    public void addRef(String ref) {
        List<String> refs = this.getRefs();
        refs.add(ref);
        this.set(FLD_REFS, StringTool.join(refs, (String)","));
    }

    public void removeRef(String ref) {
        List<String> refs = this.getRefs();
        refs.remove(ref);
        this.set(FLD_REFS, StringTool.join(refs, (String)","));
    }

    public String getLabel() {
        return this.get(FLD_TITLE);
    }

    public boolean delete() {
        Query qbe = new Query(Note.class);
        qbe.add(FLD_PARENT, "=", this.getId());
        List list = qbe.execute();
        for (Note note : list) {
            note.delete();
        }
        return super.delete();
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public static Note load(String id) {
        return new Note(id);
    }

    protected Note(String id) {
        super(id);
    }

    protected Note() {
    }
}

