/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.molemax.views2;

import org.eclipse.nebula.animation.AnimationRunner;
import org.eclipse.nebula.animation.effects.IEffect;
import org.eclipse.nebula.animation.effects.SetColorEffect;
import org.eclipse.nebula.animation.movement.ExpoOut;
import org.eclipse.nebula.animation.movement.IMovement;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;

public class HoverListener
implements MouseMoveListener,
MouseTrackListener,
MouseWheelListener {
    private static final String ANIMATION_DATA = "hoverAnimation";
    private Color backgroundColor = null;
    private Color hoverColor = null;
    GalleryItem current = null;
    Gallery gallery = null;
    int durationIn = 1000;
    int durationOut = 1000;
    GalleryItem galleryItem;

    public HoverListener(Gallery gallery, Color background, Color hover, int durationIn, int durationOut) {
        this.init(background, hover, durationIn, durationOut);
        this.gallery = gallery;
        gallery.addMouseMoveListener((MouseMoveListener)this);
        gallery.addMouseTrackListener((MouseTrackListener)this);
        gallery.addMouseWheelListener((MouseWheelListener)this);
    }

    public HoverListener(GalleryItem galleryItem, Color background, Color hover, int durationIn, int durationOut) {
        this.init(background, hover, durationIn, durationOut);
        this.galleryItem = galleryItem;
        this.gallery = galleryItem.getParent();
    }

    private void init(Color background, Color hover, int durationIn, int durationOut) {
        this.setBackgroundColor(background);
        this.setHoverColor(hover);
        this.durationIn = durationIn;
        this.durationOut = durationOut;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getHoverColor() {
        return this.hoverColor;
    }

    public void setHoverColor(Color hoverColor) {
        this.hoverColor = hoverColor;
    }

    public void mouseMove(MouseEvent e) {
        this.updateHover(e);
    }

    public void mouseEnter(MouseEvent e) {
        this.updateHover(e);
    }

    public void mouseExit(MouseEvent e) {
        if (this.current != null && !this.current.isDisposed()) {
            this.animateBackgroundColor(this.current, this.backgroundColor, this.durationOut);
        }
        this.current = null;
    }

    public void mouseHover(MouseEvent e) {
    }

    private void animateBackgroundColor(GalleryItem item, Color color, int duration) {
        if (item == null || item.isDisposed()) {
            return;
        }
        if (item != null) {
            Color bg;
            Object o = item.getData(ANIMATION_DATA);
            if (o != null && o instanceof AnimationRunner) {
                ((AnimationRunner)o).cancel();
            }
            if ((bg = item.getBackground()) == null) {
                bg = this.backgroundColor;
            }
            AnimationRunner animation = new AnimationRunner();
            item.setData(ANIMATION_DATA, (Object)animation);
            animation.runEffect((IEffect)new SetColorEffect((SetColorEffect.IColoredObject)new GalleryItemBackgroundColorAdapter(item), bg, color, (long)duration, (IMovement)new ExpoOut(), (Runnable)new AnimationDataCleaner(item), (Runnable)new AnimationDataCleaner(item)));
        }
    }

    private void updateHover(MouseEvent e) {
        GalleryItem item = ((Gallery)e.widget).getItem(new Point(e.x, e.y));
        if (item != this.current) {
            this.animateBackgroundColor(this.current, this.backgroundColor, this.durationOut);
            this.animateBackgroundColor(item, this.hoverColor, this.durationIn);
            this.current = item;
        }
    }

    public void mouseScrolled(MouseEvent e) {
        this.updateHover(e);
    }

    public class AnimationDataCleaner
    implements Runnable {
        private GalleryItem item;

        public AnimationDataCleaner(GalleryItem item) {
            this.item = item;
        }

        @Override
        public void run() {
            if (!this.item.isDisposed()) {
                this.item.setData(HoverListener.ANIMATION_DATA, null);
            }
        }
    }

    public class GalleryItemBackgroundColorAdapter
    implements SetColorEffect.IColoredObject {
        GalleryItem item;

        public GalleryItemBackgroundColorAdapter(GalleryItem item) {
            this.item = item;
        }

        public Color getColor() {
            if (!this.item.isDisposed()) {
                return this.item.getBackground();
            }
            return null;
        }

        public void setColor(Color c) {
            if (!this.item.isDisposed()) {
                this.item.setBackground(c);
            }
        }
    }
}

