/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.molemax.views;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.molemax.Messages;
import ch.elexis.molemax.data.Tracker;
import ch.elexis.molemax.views.Overview;
import ch.rgw.tools.TimeTool;
import java.io.File;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ImageSlot
extends Composite
implements DropTargetListener {
    public static final int LEFT_1 = 0;
    public static final int FRONT_1 = 1;
    public static final int RIGHT_1 = 2;
    public static final int BACK_1 = 3;
    public static final int LEFT_2 = 4;
    public static final int FRONT_2 = 5;
    public static final int RIGHT_2 = 6;
    public static final int BACK_2 = 7;
    public static final int LEFT_3 = 8;
    public static final int FRONT_3 = 9;
    public static final int RIGHT_3 = 10;
    public static final int BACK_3 = 11;
    public static final String CAPTION_NOOP = Messages.ImageSlot_notPermitted;
    public static final String TEXT_NOOP = Messages.ImageSlot_insufficientRights;
    public static final String INSUFF_RIGHTS = Messages.ImageSlot_insufficientRights2;
    private Tracker[] myTracker;
    final int mySlot;
    private final Overview home;
    private final MenuItem mDelete;

    public ImageSlot(final Overview home, Composite parent, int slotNr) {
        super(parent, 2048);
        DropTarget dt = new DropTarget((Control)this, 1);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)this);
        this.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.myTracker = home.trackers[slotNr];
        this.mySlot = slotNr;
        this.home = home;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                double scale = 1.0;
                if (ImageSlot.this.myTracker.length > 0 && ImageSlot.this.myTracker[0] != null) {
                    Point pt = ImageSlot.this.getSize();
                    if (AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(Tracker.class, (Right)Right.VIEW))) {
                        ImageData idata;
                        Image img = ImageSlot.this.myTracker[0].createImage();
                        if (img != null && (idata = img.getImageData()) != null) {
                            scale = (double)pt.x / (double)idata.width;
                            gc.drawImage(img, 0, 0, idata.width, idata.height, 0, 0, (int)Math.round((double)idata.width * scale), (int)Math.round((double)idata.height * scale));
                        }
                    } else {
                        SWTHelper.writeCentered((GC)gc, (String)INSUFF_RIGHTS, (Rectangle)new Rectangle(0, 0, pt.x, pt.y));
                    }
                }
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    ImageSlot ims = (ImageSlot)((Object)e.getSource());
                    home.dispRow.rightContents.setslot(ims.mySlot);
                    home.setTopControl(home.dispRow);
                    home.dispRow.setRow(ims.mySlot % 4);
                }
            }
        });
        Menu menu = new Menu((Control)this);
        this.mDelete = new MenuItem(menu, 0);
        this.mDelete.setText(Messages.ImageSlot_delete);
        this.mDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int num = ImageSlot.this.myTracker.length;
                Object question = Messages.ImageSlot_reallydelete;
                if (num > 1) {
                    question = Messages.ImageSlot_these + Integer.toString(num) + Messages.ImageSlot_imagesdelete;
                }
                if (SWTHelper.askYesNo((String)Messages.ImageSlot_imageDel, (String)question)) {
                    Tracker.delete(ImageSlot.this.myTracker);
                    ImageSlot.this.redraw();
                }
            }
        });
        this.setMenu(menu);
        this.setUser();
    }

    public void setUser() {
        this.mDelete.setEnabled(AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(Tracker.class, (Right)Right.DELETE)));
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        if (AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(Tracker.class, (Right)Right.UPDATE))) {
            String[] files = (String[])event.data;
            TimeTool today = new TimeTool();
            TimeTool seq = new TimeTool(this.home.date);
            long diff = today.diff(seq, 86400000L);
            if (diff > 1L && SWTHelper.askYesNo((String)Messages.ImageSlot_newsequence, (String)(Messages.ImageSlot_chosensequenceis + diff + Messages.ImageSlot_daysold))) {
                this.home.setPatient(this.home.pat, today.toString(4));
            }
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (this.myTracker.length == 0) {
                    this.myTracker = new Tracker[1];
                    this.myTracker[0] = new Tracker(this.home.pat, this.home.date, this.mySlot, new File(file));
                } else if (SWTHelper.askYesNo((String)Messages.ImageSlot_replace, (String)Messages.ImageSlot_deleteall)) {
                    Tracker.delete(this.myTracker);
                    this.myTracker = new Tracker[1];
                    this.myTracker[0] = new Tracker(this.home.pat, this.home.date, this.mySlot, new File(file));
                }
                ++n2;
            }
            this.redraw();
        } else {
            SWTHelper.alert((String)CAPTION_NOOP, (String)TEXT_NOOP);
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void setImage(File file) {
        if (AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(Tracker.class, (Right)Right.UPDATE))) {
            if (file.getName().startsWith("base")) {
                if (this.myTracker.length != 0) {
                    if (SWTHelper.askYesNo((String)Messages.ImageSlot_replace, (String)Messages.ImageSlot_deleteall)) {
                        Tracker.delete(this.myTracker);
                    } else {
                        return;
                    }
                }
                this.myTracker = new Tracker[1];
                this.myTracker[0] = new Tracker(this.home.pat, this.home.date, this.mySlot, file);
            } else if (this.myTracker.length == 0) {
                SWTHelper.showError((String)"Fehlerhafte Struktur", (String)("Dieses Verzeichnis " + file.getParentFile().getAbsolutePath() + " enth\u00e4lt kein Basisbild"));
            } else {
                String[] koord = file.getName().split("-");
                Rectangle rec = new Rectangle(Integer.parseInt(koord[0]), Integer.parseInt(koord[1]), Integer.parseInt(koord[2]), Integer.parseInt(koord[3]));
                Tracker t = new Tracker(this.home.pat, this.myTracker[0], this.home.date, this.mySlot, rec);
                Tracker[] tOld = this.home.trackers[this.mySlot];
                Tracker[] tNew = new Tracker[tOld.length + 1];
                int i = 0;
                while (i < tOld.length) {
                    tNew[i] = tOld[i];
                    ++i;
                }
                tNew[tOld.length] = t;
                this.home.trackers[this.mySlot] = tNew;
                t.setFile(file);
            }
        }
    }
}

