/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.molemax.views;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.molemax.Messages;
import ch.elexis.molemax.data.Tracker;
import ch.elexis.molemax.views.Overview;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public class TimeMachineDisplay
extends ScrolledComposite {
    Overview parent;
    Composite inlay;
    List<Tracker> myTracker;

    TimeMachineDisplay(Overview parent, Composite c) {
        super(c, 768);
        this.parent = parent;
    }

    void setTracker(List<Tracker> t) {
        this.myTracker = t;
        if (this.inlay != null) {
            this.inlay.dispose();
        }
        this.inlay = new Composite((Composite)this, 0);
        this.inlay.setLayout((Layout)new GridLayout(2, false));
        this.setContent((Control)this.inlay);
        int w = 300;
        int h = 0;
        Label lb = SWTHelper.createHyperlink((Composite)this.inlay, (String)Messages.TimeMachineDisplay_back, (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TimeMachineDisplay.this.parent.setTopControl(TimeMachineDisplay.this.parent.dispRow);
            }
        });
        lb.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        for (Tracker tracker : this.myTracker) {
            Composite cAnn = new Composite(this.inlay, 2048);
            Composite cImg = new Composite(this.inlay, 2048);
            cAnn.setLayout((Layout)new GridLayout());
            Image img = tracker.createImage();
            if (img == null) continue;
            ImageData imd = img.getImageData();
            cImg.setBounds(imd.x, imd.y, imd.width + 20, imd.height + 20);
            cImg.setBackgroundImage(img);
            TimeTool date = new TimeTool(tracker.get(Messages.TimeMachineDisplay_date));
            new Label(cAnn, 0).setText(date.toString(4));
            Text tAnn = SWTHelper.createText((Composite)cAnn, (int)8, (int)2048);
            tAnn.setData((Object)tracker);
            tAnn.setText(tracker.getInfoString("annotation"));
            tAnn.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    Text text = (Text)e.getSource();
                    Tracker t = (Tracker)((Object)text.getData());
                    String newMsg = text.getText();
                    t.setInfoString("annotation", newMsg);
                }
            });
            GridData ldImg = new GridData(cImg.getBounds().width, cImg.getBounds().height);
            GridData ldAnn = new GridData(100, ldImg.heightHint);
            cAnn.setLayoutData((Object)ldAnn);
            cImg.setLayoutData((Object)ldImg);
            h += cImg.getBounds().height;
            int wTest = cImg.getBounds().width + 100;
            if (wTest <= w) continue;
            w = wTest;
        }
        if (h == 0) {
            h = 20;
        }
        this.inlay.setBounds(0, 0, w, h);
        this.layout();
    }
}

