/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.molemax.views;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.molemax.Messages;
import ch.elexis.molemax.views.ImageSlot;
import ch.elexis.molemax.views.Overview;
import java.io.File;
import java.util.List;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tracker;

public class DetailDisplay
extends Composite {
    private Tracker mouseTracker;
    private final DetailDisplay self = this;
    private final Overview home;
    private int actSlot;
    private final Menu menu;
    private final MenuItem mDelete;

    public DetailDisplay(Composite parent, Overview h) {
        super(parent, 0);
        this.home = h;
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    DetailDisplay.this.mouseTracker = new Tracker((Composite)DetailDisplay.this.self, 16);
                    Rectangle beg = new Rectangle(e.x, e.y, 5, 5);
                    DetailDisplay.this.mouseTracker.setRectangles(new Rectangle[]{beg});
                    DetailDisplay.this.mouseTracker.open();
                    Rectangle[] rec = DetailDisplay.this.mouseTracker.getRectangles();
                    if (rec[0].width > 10 && rec[0].height > 10) {
                        ch.elexis.molemax.data.Tracker in = new ch.elexis.molemax.data.Tracker(DetailDisplay.this.home.pat, DetailDisplay.this.home.trackers[DetailDisplay.this.actSlot][0], DetailDisplay.this.home.date, DetailDisplay.this.actSlot, rec[0]);
                        ch.elexis.molemax.data.Tracker[] tOld = DetailDisplay.this.home.trackers[DetailDisplay.this.actSlot];
                        ch.elexis.molemax.data.Tracker[] tNew = new ch.elexis.molemax.data.Tracker[tOld.length + 1];
                        int i = 0;
                        while (i < tOld.length) {
                            tNew[i] = tOld[i];
                            ++i;
                        }
                        tNew[tOld.length] = in;
                        DetailDisplay.this.home.trackers[DetailDisplay.this.actSlot] = tNew;
                        DetailDisplay.this.self.redraw();
                    }
                } else {
                    ch.elexis.molemax.data.Tracker[] myTracker = DetailDisplay.this.home.trackers[DetailDisplay.this.actSlot];
                    int t = ch.elexis.molemax.data.Tracker.getTrackerAtPoint(myTracker, e.x, e.y);
                    if (t > 0) {
                        DetailDisplay.this.setMenu(DetailDisplay.this.menu);
                        DetailDisplay.this.menu.setData((Object)t);
                    } else {
                        DetailDisplay.this.setMenu(null);
                    }
                    super.mouseDown(e);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                ch.elexis.molemax.data.Tracker[] myTracker = DetailDisplay.this.home.trackers[DetailDisplay.this.actSlot];
                List<ch.elexis.molemax.data.Tracker> list = ch.elexis.molemax.data.Tracker.getTrackersAtPoint(myTracker, e.x, e.y);
                if (list.size() > 0) {
                    DetailDisplay.this.home.tmd.setTracker(list);
                    DetailDisplay.this.home.setTopControl((Composite)DetailDisplay.this.home.tmd);
                }
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                if (AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(ch.elexis.molemax.data.Tracker.class, (Right)Right.VIEW))) {
                    ch.elexis.molemax.data.Tracker[] myTracker = DetailDisplay.this.home.trackers[DetailDisplay.this.actSlot];
                    if (myTracker != null) {
                        int i = 0;
                        while (i < myTracker.length) {
                            if (myTracker[i] != null) {
                                Image img = myTracker[i].createImage();
                                Rectangle bounds = myTracker[i].getBounds();
                                if (bounds != null) {
                                    if (img == null) {
                                        gc.drawRectangle(bounds);
                                    } else if (i == 0) {
                                        gc.drawImage(img, bounds.x, bounds.y);
                                    } else {
                                        ImageData idata = img.getImageData();
                                        if (idata != null) {
                                            double scale = (double)bounds.width / (double)idata.width;
                                            gc.drawImage(img, 0, 0, idata.width, idata.height, bounds.x, bounds.y, (int)Math.round((double)idata.width * scale), (int)Math.round((double)idata.height * scale));
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                } else {
                    SWTHelper.writeCentered((GC)gc, (String)ImageSlot.INSUFF_RIGHTS, (Rectangle)DetailDisplay.this.getBounds());
                }
            }
        });
        DropTarget dt = new DropTarget((Control)this, 1);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                if (!AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(ch.elexis.molemax.data.Tracker.class, (Right)Right.UPDATE))) {
                    SWTHelper.alert((String)ImageSlot.CAPTION_NOOP, (String)ImageSlot.TEXT_NOOP);
                    return;
                }
                ch.elexis.molemax.data.Tracker[] myTracker = DetailDisplay.this.home.trackers[DetailDisplay.this.actSlot];
                Point pC = DetailDisplay.this.self.toControl(event.x, event.y);
                int t = ch.elexis.molemax.data.Tracker.getTrackerAtPoint(myTracker, pC.x, pC.y);
                if (t > 0) {
                    String[] files = (String[])event.data;
                    ch.elexis.molemax.data.Tracker tracker = myTracker[t];
                    Image img = tracker.createImage();
                    if (img == null) {
                        tracker.setFile(new File(files[0]));
                    } else {
                        ch.elexis.molemax.data.Tracker in = new ch.elexis.molemax.data.Tracker(DetailDisplay.this.home.pat, myTracker[0], null, DetailDisplay.this.actSlot, myTracker[t].getBounds());
                        in.setFile(new File(files[0]));
                        ch.elexis.molemax.data.Tracker[] tOld = DetailDisplay.this.home.trackers[DetailDisplay.this.actSlot];
                        ch.elexis.molemax.data.Tracker[] tNew = new ch.elexis.molemax.data.Tracker[tOld.length + 1];
                        int i = 0;
                        while (i < tOld.length) {
                            tNew[i] = tOld[i];
                            ++i;
                        }
                        tNew[tOld.length] = in;
                        DetailDisplay.this.home.trackers[DetailDisplay.this.actSlot] = tNew;
                        DetailDisplay.this.self.redraw();
                    }
                    DetailDisplay.this.redraw();
                }
            }

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void dragOver(DropTargetEvent event) {
                ch.elexis.molemax.data.Tracker[] myTracker = DetailDisplay.this.home.trackers[DetailDisplay.this.actSlot];
                Point pC = DetailDisplay.this.self.toControl(event.x, event.y);
                int t = ch.elexis.molemax.data.Tracker.getTrackerAtPoint(myTracker, pC.x, pC.y);
                event.detail = t == 0 ? 0 : 1;
            }
        });
        this.menu = new Menu((Control)this);
        this.mDelete = new MenuItem(this.menu, 0);
        this.mDelete.setText(Messages.DetailDisplay_deleteFrame);
        this.mDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SWTHelper.askYesNo((String)Messages.DetailDisplay_deleteFrameAndImage, (String)Messages.DetailDisplay_deleteReally)) {
                    Integer t = (Integer)((MenuItem)e.getSource()).getParent().getData();
                    ch.elexis.molemax.data.Tracker[] myTracker = DetailDisplay.this.home.trackers[DetailDisplay.this.actSlot];
                    myTracker[t].delete();
                    ch.elexis.molemax.data.Tracker[] tNew = new ch.elexis.molemax.data.Tracker[myTracker.length - 1];
                    int i = 0;
                    int j = 0;
                    while (i < myTracker.length) {
                        if (i != t) {
                            tNew[j++] = myTracker[i];
                        }
                        ++i;
                    }
                    DetailDisplay.this.home.trackers[DetailDisplay.this.actSlot] = tNew;
                    DetailDisplay.this.self.redraw();
                }
            }
        });
        this.setUser();
    }

    public void setUser() {
        this.mDelete.setEnabled(AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(ch.elexis.molemax.data.Tracker.class, (Right)Right.UPDATE)));
    }

    void setslot(int slot) {
        this.actSlot = slot;
        ch.elexis.molemax.data.Tracker[] myTracker = this.home.trackers[this.actSlot];
        if (myTracker.length > 0) {
            Image img = myTracker[0].createImage();
            if (img != null) {
                ImageData imd = img.getImageData();
                this.setSize(imd.width + this.getBorderWidth(), imd.height);
                this.getParent().layout(true);
            }
            this.redraw();
        }
    }
}

