/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.util;

import ch.elexis.core.services.IConfigService;
import ch.elexis.mednet.webapi.core.messages.Messages;
import ch.elexis.mednet.webapi.ui.Activator;
import ch.elexis.mednet.webapi.ui.util.CompositeEffectHandler;
import ch.elexis.mednet.webapi.ui.util.ImageUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ButtonFactory {
    public static Composite createToggleButtonComposite(Composite parent, String iconPathDefault, String iconPathActive, final String buttonText, Color customBlue) {
        final Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setBackground(customBlue);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 128, true, false);
        gridData.heightHint = 80;
        buttonComposite.setLayoutData((Object)gridData);
        final Label iconLabel = new Label(buttonComposite, 0);
        final Image defaultIcon = ImageUtil.getScaledImage(parent.getDisplay(), iconPathDefault, 32, 32, iconLabel);
        final Image activeIcon = ImageUtil.getScaledImage(parent.getDisplay(), iconPathActive, 32, 32, iconLabel);
        iconLabel.setImage(defaultIcon);
        iconLabel.setBackground(customBlue);
        iconLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        final Label textLabel = new Label(buttonComposite, 0x1000040);
        textLabel.setText(buttonText);
        textLabel.setBackground(customBlue);
        textLabel.setForeground(parent.getDisplay().getSystemColor(1));
        textLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        final boolean[] isConnected = new boolean[1];
        CompositeEffectHandler.addHoverEffectWithoutChangingActiveState(buttonComposite, iconLabel, textLabel, defaultIcon, customBlue, isConnected);
        MouseAdapter clickListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                boolean bl = isConnected[0] = !isConnected[0];
                if (isConnected[0]) {
                    String downloadPath = ButtonFactory.getDownloadStore();
                    if (downloadPath == null || downloadPath.trim().isEmpty()) {
                        iconLabel.setImage(defaultIcon);
                        textLabel.setText(buttonText);
                        MessageDialog.openWarning((Shell)buttonComposite.getShell(), (String)Messages.MedNetMainComposite_noPathWarningTitle, (String)Messages.MedNetMainComposite_noPathWarningMessage);
                        isConnected[0] = false;
                        return;
                    }
                    iconLabel.setImage(activeIcon);
                    textLabel.setText(Messages.MedNetMainComposite_deactivateImport);
                    textLabel.setToolTipText(Messages.MedNetMainComposite_connectedTooltip);
                    Activator.getInstance().startScheduler();
                    Activator.getInstance().setOnSchedulerError(() -> Display.getDefault().asyncExec(() -> {
                        iconLabel.setImage(defaultIcon);
                        textLabel.setText(buttonText);
                        textLabel.setToolTipText(Messages.MedNetMainComposite_schedulerErrorMessage);
                        blArray[0] = false;
                    }));
                } else {
                    iconLabel.setImage(defaultIcon);
                    textLabel.setText(buttonText);
                    textLabel.setToolTipText(Messages.MedNetMainComposite_disconnectedTooltip);
                    Activator.getInstance().stopScheduler();
                }
            }
        };
        buttonComposite.addMouseListener((MouseListener)clickListener);
        iconLabel.addMouseListener((MouseListener)clickListener);
        textLabel.addMouseListener((MouseListener)clickListener);
        Activator.getInstance().setOnSchedulerError(() -> parent.getDisplay().asyncExec(() -> {
            blArray[0] = false;
            iconLabel.setImage(defaultIcon);
            textLabel.setText(buttonText);
            textLabel.setToolTipText(Messages.MedNetMainComposite_disconnectedTooltip);
            MessageDialog.openError((Shell)parent.getShell(), (String)Messages.MedNetMainComposite_schedulerErrorTitle, (String)Messages.MedNetMainComposite_schedulerErrorMessage);
        }));
        buttonComposite.addDisposeListener(e -> {
            if (defaultIcon != null && !defaultIcon.isDisposed()) {
                defaultIcon.dispose();
            }
            if (activeIcon != null && !activeIcon.isDisposed()) {
                activeIcon.dispose();
            }
        });
        return buttonComposite;
    }

    public static Composite createButtonComposite(Composite parent, String iconPathDefault, String iconPathHover, String buttonText, Color customBlue, Runnable onClickAction) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setBackground(customBlue);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 128, true, false);
        gridData.heightHint = 80;
        buttonComposite.setLayoutData((Object)gridData);
        Label iconLabel = new Label(buttonComposite, 0);
        Image defaultIcon = ImageUtil.getScaledImage(parent.getDisplay(), iconPathDefault, 32, 32, iconLabel);
        Image hoverIcon = ImageUtil.getScaledImage(parent.getDisplay(), iconPathHover, 32, 32, iconLabel);
        iconLabel.setImage(defaultIcon);
        iconLabel.setBackground(customBlue);
        iconLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        Label textLabel = new Label(buttonComposite, 0x1000040);
        textLabel.setText(buttonText);
        textLabel.setBackground(customBlue);
        textLabel.setForeground(parent.getDisplay().getSystemColor(1));
        textLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        CompositeEffectHandler.addHoverEffect(buttonComposite, iconLabel, textLabel, defaultIcon, hoverIcon, customBlue);
        CompositeEffectHandler.addPressReleaseEffect(buttonComposite, iconLabel, textLabel, hoverIcon, onClickAction, customBlue);
        buttonComposite.addDisposeListener(e -> {
            if (defaultIcon != null && !defaultIcon.isDisposed()) {
                defaultIcon.dispose();
            }
            if (hoverIcon != null && !hoverIcon.isDisposed()) {
                hoverIcon.dispose();
            }
        });
        return buttonComposite;
    }

    private static String getDownloadStore() {
        String downloadPath = "";
        try {
            IConfigService configService;
            ServiceReference serviceReference;
            BundleContext context = FrameworkUtil.getBundle(ButtonFactory.class).getBundleContext();
            if (context != null && (serviceReference = context.getServiceReference(IConfigService.class)) != null && (configService = (IConfigService)context.getService(serviceReference)) != null) {
                downloadPath = configService.getActiveUserContact("MedNetDownloadpathPreference", "");
                return downloadPath;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return downloadPath;
    }
}

