/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.handler;

import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.MimeType;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ImportOmnivoreUtil {
    private static IDocumentStore omnivoreDocumentStore;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Reference(target="(storeid=ch.elexis.data.store.omnivore)")
    public void setDocumentStore(IDocumentStore documentStore) {
        omnivoreDocumentStore = documentStore;
    }

    @Nullable
    public String tryImportForPatient(File file, String patientNo, String fileName) {
        List lPat = new Query(Patient.class, "PatientNr", patientNo).execute();
        if (lPat.size() == 1 && !this.isFileOpened(file)) {
            String category;
            Patient pat;
            block17: {
                pat = (Patient)lPat.get(0);
                category = ImportOmnivoreUtil.getCategory(file);
                if (category != null && !category.equals("-") && !category.equals("??")) {
                    this.ensureCategoryExists(category);
                }
                long heapSize = Runtime.getRuntime().totalMemory();
                long length = file.length();
                if (length < heapSize) break block17;
                this.logger.warn("Skipping " + file.getAbsolutePath() + " as bigger than heap size. (#3652)");
                return null;
            }
            try {
                IDocument newDocument = omnivoreDocumentStore.createDocument(pat.getId(), fileName, category);
                String extension = this.getFileExtension(file);
                if (extension != null && (newDocument.getMimeType() == null || newDocument.getMimeType().isEmpty())) {
                    MimeType mimetyp = MimeType.getByExtension((String)extension);
                    if (mimetyp != MimeType.undefined) {
                        newDocument.setMimeType(mimetyp.getContentType());
                    } else {
                        newDocument.setMimeType(file.getName());
                    }
                }
                Throwable throwable = null;
                Object var14_14 = null;
                try (FileInputStream contentStream = new FileInputStream(file);){
                    omnivoreDocumentStore.saveDocument(newDocument, (InputStream)contentStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                file.delete();
                return newDocument.getId();
            }
            catch (Exception ex) {
                this.logger.error("An error occurred while trying to import the document for patient with ID {}.", (Object)patientNo, (Object)ex);
            }
        }
        return null;
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1 || lastIndexOf == 0) {
            return "";
        }
        return name.substring(lastIndexOf + 1);
    }

    /*
     * Exception decompiling
     */
    private boolean isFileOpened(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getDirectory(String defaultValue, IConfigService configService) {
        String pluginId = "ch.elexis.mednet.webapi.ui";
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(pluginId);
        String dir = node.get("MedNetDownloadpathPreference", "");
        return dir;
    }

    public static String getCategory(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return "Error in Mednet path";
        }
        String category = parent.getName();
        return category;
    }

    public void ensureCategoryExists(String categoryName) {
        List existingCategories = omnivoreDocumentStore.getCategories();
        boolean categoryExists = existingCategories.stream().anyMatch(category -> categoryName.equalsIgnoreCase(category.getName()));
        if (!categoryExists) {
            this.createCategory(categoryName);
        }
    }

    private void createCategory(String categoryName) {
        ICategory newCategory = omnivoreDocumentStore.createCategory(categoryName);
        LoggerFactory.getLogger(this.getClass()).info("Kategorie erstellt: " + categoryName);
    }
}

