/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui;

import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.mednet.webapi.core.IMednetAuthService;
import ch.elexis.mednet.webapi.core.fhir.resources.util.FileDownloader;
import ch.elexis.mednet.webapi.ui.handler.ImportOmnivore;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static Activator instance;
    private ScheduledExecutorService scheduler;
    private Runnable onSchedulerError;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        logger.info("Activator initialized, scheduler is not started yet.");
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        this.stopScheduler();
        super.stop(context);
        logger.info("Activator stopped.");
    }

    public static Activator getInstance() {
        return instance;
    }

    public void startScheduler() {
        if (this.scheduler == null || this.scheduler.isShutdown()) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BundleContext context = Activator.this.getBundle().getBundleContext();
                        ServiceReference serviceReference = context.getServiceReference(IMednetAuthService.class);
                        IMednetAuthService authService = (IMednetAuthService)context.getService(serviceReference);
                        boolean downloadSuccess = false;
                        if (authService != null) {
                            FileDownloader downloader = new FileDownloader(authService);
                            downloadSuccess = downloader.downloadForms();
                            if (downloadSuccess) {
                                logger.info("File download initiated successfully.");
                            } else {
                                logger.error("File download failed.");
                            }
                        } else {
                            logger.error("IMednetAuthService not available.");
                        }
                        if (downloadSuccess) {
                            IStatus status = new ImportOmnivore().run();
                            if (!status.isOK()) {
                                throw new TaskException(6, "Import failed with status: " + status.getMessage());
                            }
                            logger.info("Import completed successfully.");
                        } else {
                            Activator.this.notifySchedulerError();
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Error during task execution: {}", (Object)ex.getMessage(), (Object)ex);
                        Activator.this.notifySchedulerError();
                    }
                }
            }, 0L, 5L, TimeUnit.MINUTES);
            logger.info("Scheduler started with a 5-minute interval.");
        } else {
            logger.info("Scheduler is already running.");
        }
    }

    public void stopScheduler() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdownNow();
            logger.info("Scheduler shut down.");
        }
    }

    public void setOnSchedulerError(Runnable onSchedulerError) {
        this.onSchedulerError = onSchedulerError;
    }

    public void notifySchedulerError() {
        if (this.onSchedulerError != null) {
            this.onSchedulerError.run();
        }
    }
}

