/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.util;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class CompositeEffectHandler {
    public static void addHoverEffect(final Composite composite, final Label iconLabel, final Label textLabel, final Image defaultIcon, final Image hoverIcon, final Color customBlue) {
        MouseTrackAdapter hoverEffect = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                composite.setBackground(composite.getDisplay().getSystemColor(1));
                iconLabel.setImage(hoverIcon);
                textLabel.setForeground(customBlue);
                textLabel.setBackground(composite.getDisplay().getSystemColor(1));
                iconLabel.setBackground(composite.getDisplay().getSystemColor(1));
            }

            public void mouseExit(MouseEvent e) {
                composite.setBackground(customBlue);
                iconLabel.setImage(defaultIcon);
                textLabel.setForeground(composite.getDisplay().getSystemColor(1));
                textLabel.setBackground(customBlue);
                iconLabel.setBackground(customBlue);
            }
        };
        composite.addMouseTrackListener((MouseTrackListener)hoverEffect);
        iconLabel.addMouseTrackListener((MouseTrackListener)hoverEffect);
        textLabel.addMouseTrackListener((MouseTrackListener)hoverEffect);
    }

    public static void addHoverEffectBreadcrumbNavigation(final Composite composite, final Label iconLabel, final Label textLabel, final Image defaultIcon, final Image hoverIcon, final Color customBlue) {
        MouseTrackAdapter hoverEffect = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                composite.setBackground(customBlue);
                iconLabel.setImage(hoverIcon);
                textLabel.setForeground(composite.getDisplay().getSystemColor(1));
                textLabel.setBackground(customBlue);
                iconLabel.setBackground(customBlue);
            }

            public void mouseExit(MouseEvent e) {
                composite.setBackground(composite.getDisplay().getSystemColor(1));
                iconLabel.setImage(defaultIcon);
                textLabel.setForeground(customBlue);
                textLabel.setBackground(composite.getDisplay().getSystemColor(1));
                iconLabel.setBackground(composite.getDisplay().getSystemColor(1));
            }
        };
        composite.addMouseTrackListener((MouseTrackListener)hoverEffect);
        iconLabel.addMouseTrackListener((MouseTrackListener)hoverEffect);
        textLabel.addMouseTrackListener((MouseTrackListener)hoverEffect);
    }

    public static void addPressReleaseEffect(final Composite composite, final Label iconLabel, final Label textLabel, final Image hoverIcon, final Runnable onClickAction, final Color customBlue) {
        MouseAdapter pressReleaseEffect = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                composite.setBackground(composite.getDisplay().getSystemColor(15));
                textLabel.setBackground(composite.getDisplay().getSystemColor(15));
                iconLabel.setBackground(composite.getDisplay().getSystemColor(15));
            }

            public void mouseUp(MouseEvent e) {
                if (composite.getBounds().contains(composite.getDisplay().map(null, (Control)composite, e.x, e.y))) {
                    composite.setBackground(composite.getDisplay().getSystemColor(1));
                    textLabel.setForeground(customBlue);
                    textLabel.setBackground(composite.getDisplay().getSystemColor(1));
                    iconLabel.setImage(hoverIcon);
                } else {
                    composite.setBackground(customBlue);
                    iconLabel.setImage(hoverIcon);
                    textLabel.setForeground(customBlue);
                    textLabel.setBackground(composite.getDisplay().getSystemColor(1));
                    iconLabel.setBackground(composite.getDisplay().getSystemColor(1));
                }
                onClickAction.run();
            }
        };
        composite.addMouseListener((MouseListener)pressReleaseEffect);
        iconLabel.addMouseListener((MouseListener)pressReleaseEffect);
        textLabel.addMouseListener((MouseListener)pressReleaseEffect);
    }

    public static void addHoverEffectWithoutChangingActiveState(final Composite composite, final Label iconLabel, final Label textLabel, final Image defaultIcon, final Color customBlue, final boolean[] isActive) {
        MouseTrackAdapter hoverEffect = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                composite.setBackground(composite.getDisplay().getSystemColor(1));
                if (!isActive[0]) {
                    iconLabel.setImage(defaultIcon);
                }
                textLabel.setForeground(customBlue);
                textLabel.setBackground(composite.getDisplay().getSystemColor(1));
                iconLabel.setBackground(composite.getDisplay().getSystemColor(1));
            }

            public void mouseExit(MouseEvent e) {
                composite.setBackground(customBlue);
                if (!isActive[0]) {
                    iconLabel.setImage(defaultIcon);
                }
                textLabel.setForeground(composite.getDisplay().getSystemColor(1));
                textLabel.setBackground(customBlue);
                iconLabel.setBackground(customBlue);
            }
        };
        composite.addMouseTrackListener((MouseTrackListener)hoverEffect);
        iconLabel.addMouseTrackListener((MouseTrackListener)hoverEffect);
        textLabel.addMouseTrackListener((MouseTrackListener)hoverEffect);
    }
}

