/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.handler;

import ch.elexis.mednet.webapi.core.IMednetAuthService;
import ch.elexis.mednet.webapi.ui.handler.DataHandler;
import java.util.HashMap;
import java.util.Optional;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceHelper {
    private static final Logger logger = LoggerFactory.getLogger(ServiceHelper.class);

    public static Optional<String> getAuthToken(String tokenGroup) {
        BundleContext context = FrameworkUtil.getBundle(DataHandler.class).getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMednetAuthService.class);
        if (serviceReference != null) {
            IMednetAuthService authService = (IMednetAuthService)context.getService(serviceReference);
            try {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("token_group", tokenGroup);
                Optional optional = authService.getToken(parameters);
                return optional;
            }
            catch (Exception ex) {
                logger.error("Error when retrieving the authentication token", (Throwable)ex);
            }
            finally {
                context.ungetService(serviceReference);
            }
        } else {
            logger.error("ServiceReference for IMednetAuthService is null. ");
        }
        return Optional.empty();
    }
}

