/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.parts;

import ch.elexis.mednet.webapi.core.messages.Messages;
import ch.elexis.mednet.webapi.ui.handler.DataHandler;
import ch.elexis.mednet.webapi.ui.handler.TableHelper;
import ch.elexis.mednet.webapi.ui.util.UIStyleTableHelper;
import java.util.function.Consumer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CustomerComposite {
    private Composite parent;
    private Consumer<Integer> loadProvidersCallback;
    private ICustomerSelectionListener customerSelectionListener;

    public CustomerComposite(Composite parent, ICustomerSelectionListener customerSelectionListener) {
        this.parent = parent;
        this.customerSelectionListener = customerSelectionListener;
    }

    public void show() {
        this.parent.setLayout((Layout)UIStyleTableHelper.createStyledGridLayout());
        Text searchBox = new Text(this.parent, 896);
        searchBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        searchBox.setMessage(Messages.Composite_searchBoxMessage);
        Table customerTable = UIStyleTableHelper.createStyledTable(this.parent);
        String[] columnHeaders = new String[]{Messages.CustomerComposite_customerID, Messages.CustomerComposite_customerFirstName, Messages.CustomerComposite_customerLastName};
        int[] nArray = new int[3];
        nArray[1] = 150;
        nArray[2] = 150;
        int[] columnWidths = nArray;
        TableColumn[] columns = new TableColumn[columnHeaders.length];
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(customerTable, 0);
            column.setText(columnHeaders[i]);
            column.setWidth(columnWidths[i]);
            columns[i] = column;
            if (i == 0) {
                column.setResizable(false);
            }
            int columnIndex = i++;
            column.addListener(13, event -> TableHelper.sortTable(customerTable, columnIndex));
        }
        DataHandler.fetchAndDisplayCustomers(customerTable);
        searchBox.addModifyListener(event -> {
            String searchText = searchBox.getText().toLowerCase();
            TableHelper.filterTable(customerTable, searchText);
        });
        customerTable.addListener(11, event -> {
            int tableWidth = table.getClientArea().width;
            int totalWidth = 0;
            int i = 0;
            while (i < customerTable.getColumnCount() - 1) {
                totalWidth += customerTable.getColumn(i).getWidth();
                ++i;
            }
            int remainingWidth = Math.max(100, tableWidth - totalWidth);
            columns[columns.length - 1].setWidth(remainingWidth);
        });
        customerTable.addListener(8, event -> {
            TableItem[] selection = customerTable.getSelection();
            if (selection.length > 0) {
                TableItem selectedItem = selection[0];
                Integer customerId = Integer.parseInt(selectedItem.getText(0));
                String customerFirstName = selectedItem.getText(1);
                String customerLastName = selectedItem.getText(2);
                String customerName = customerFirstName + " " + customerLastName;
                if (customerId != null) {
                    this.customerSelectionListener.onCustomerSelected(customerId, customerName);
                }
            }
        });
        this.parent.layout();
    }

    public static interface ICustomerSelectionListener {
        public void onCustomerSelected(Integer var1, String var2);
    }
}

