/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.util;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class UIStyleTableHelper {
    private static Font tableFont = null;

    public static Color getBackgroundColor(Display display) {
        return new Color((Device)display, 248, 248, 248);
    }

    public static Color getTextColor(Display display) {
        return new Color((Device)display, 42, 108, 155);
    }

    public static Color getRow1Color(Display display) {
        return new Color((Device)display, 248, 248, 248);
    }

    public static Color getRow2Color(Display display) {
        return new Color((Device)display, 255, 255, 255);
    }

    public static Color getLineColor(Display display) {
        return new Color((Device)display, 200, 200, 200);
    }

    public static Font getTableFont(Display display) {
        if (tableFont == null || tableFont.isDisposed()) {
            tableFont = new Font((Device)display, new FontData("Arial", 10, 0));
        }
        return tableFont;
    }

    public static Font getHeaderFont(Display display) {
        return new Font((Device)display, new FontData("Arial", 12, 1));
    }

    public static GridLayout createStyledGridLayout() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 10;
        return layout;
    }

    public static CCombo createStyledCCombo(Composite parent) {
        Display display = parent.getDisplay();
        CCombo combo = new CCombo(parent, 2056);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        combo.setFont(UIStyleTableHelper.getTableFont(display));
        combo.setForeground(UIStyleTableHelper.getTextColor(display));
        combo.setBackground(UIStyleTableHelper.getBackgroundColor(display));
        parent.addDisposeListener(e -> {
            if (!combo.isDisposed()) {
                combo.dispose();
            }
        });
        return combo;
    }

    public static Table createStyledTable(Composite parent) {
        Display display = parent.getDisplay();
        Table table = new Table(parent, 328448);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setFont(UIStyleTableHelper.getTableFont(display));
        table.setLinesVisible(false);
        parent.addDisposeListener(e -> {
            if (!table.isDisposed()) {
                table.dispose();
            }
        });
        return table;
    }

    public static void addTableColumns(Table table, String[] columnHeaders, int[] columnWidths) {
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeaders[i]);
            column.setWidth(columnWidths[i]);
            column.setResizable(true);
            ++i;
        }
    }

    public static void styleTableRows(TableItem item, int rowIndex, Display display) {
        if (rowIndex % 2 == 0) {
            item.setBackground(UIStyleTableHelper.getRow1Color(display));
        } else {
            item.setBackground(UIStyleTableHelper.getRow2Color(display));
        }
        item.setForeground(UIStyleTableHelper.getTextColor(display));
    }

    public static void addTableLines(Table table) {
        Display display = table.getDisplay();
        final Color lineColor = UIStyleTableHelper.getLineColor(display);
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                GC gc = event.gc;
                Rectangle bounds = item.getBounds(event.index);
                gc.setForeground(lineColor);
                gc.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
                gc.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y + bounds.height);
            }
        });
    }
}

