/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources;

import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.mednet.webapi.core.fhir.resources.util.FhirResourceFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.Reference;

public class ProcedureResource {
    public static List<Procedure> createProcedures(Reference patientReference, IPatient sourcePatient, FhirResourceFactory resourceFactory) {
        IEncounter lastEncounter = ProcedureResource.getLastEncounterForPatient(sourcePatient);
        ArrayList<Procedure> procedures = new ArrayList<Procedure>();
        if (lastEncounter != null) {
            Optional<Encounter> encounterResource = Optional.ofNullable(resourceFactory.getResource(lastEncounter, IEncounter.class, Encounter.class));
            String encounterText = encounterResource.map(encounter -> encounter.getText() != null ? encounter.getText().getDivAsString() : "No text available").orElse("No encounter data available");
            Procedure procedure = new Procedure();
            procedure.setId(UUID.randomUUID().toString());
            procedure.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-procedure");
            procedure.setStatus(Procedure.ProcedureStatus.COMPLETED);
            procedure.setCode(new CodeableConcept().addCoding(new Coding().setSystem("http://snomed.info/sct").setCode("71388002").setDisplay("Procedure")).setText(encounterText));
            procedure.setSubject(patientReference);
            procedures.add(procedure);
        } else {
            Procedure procedure = new Procedure();
            procedure.setId(UUID.randomUUID().toString());
            procedure.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-procedure");
            procedure.setStatus(Procedure.ProcedureStatus.UNKNOWN);
            procedure.setCode(new CodeableConcept().addCoding(new Coding().setSystem("http://snomed.info/sct").setCode("71388002").setDisplay("No procedure data available")).setText("No encounter data available"));
            procedure.setSubject(patientReference);
            procedures.add(procedure);
        }
        return procedures;
    }

    private static IEncounter getLastEncounterForPatient(IPatient patient) {
        List encounters = EncounterServiceHolder.get().getAllEncountersForPatient(patient);
        return encounters.stream().max(Comparator.comparing(IEncounter::getTimeStamp)).orElse(null);
    }
}

