/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources;

import ch.elexis.core.model.IUser;
import ch.elexis.mednet.webapi.core.fhir.resources.util.FhirResourceFactory;
import java.util.UUID;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Reference;

public class PractitionerRoleResource {
    public PractitionerRole createPractitionerRole(IUser user, Practitioner practitioner, FhirResourceFactory resourceFactory) {
        PractitionerRole practitionerRole = resourceFactory.getResource(user, IUser.class, PractitionerRole.class);
        if (practitionerRole == null) {
            practitionerRole = new PractitionerRole();
            practitionerRole.setId(UUID.randomUUID().toString());
        }
        practitionerRole.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-practitionerRole");
        if (practitioner != null) {
            practitionerRole.setPractitioner(new Reference("urn:uuid:" + practitioner.getId()));
        }
        return practitionerRole;
    }
}

