/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.constants;

import ch.elexis.core.services.IConfigService;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLConstants {
    private static final Logger logger = LoggerFactory.getLogger(URLConstants.class);
    public static final String URL_PATIENTS = "/DoctorUser/patients";
    public static final String URL_TASKS = "/DoctorUser/tasks";
    public static final String URL_DOCUMENTS = "/DoctorUser/documents";
    public static final String URL_THERAPY = "/DoctorUser/chronic-diseases/chronic-diseases-list";

    public static String getBaseApiUrl() {
        Optional configService = OsgiServiceUtil.getServiceWait(IConfigService.class, (long)5000L);
        if (configService.isPresent()) {
            String mode = ((IConfigService)configService.get()).getActiveUserContact("mednet_mode", "DEMO");
            if ("PRODUKTIV".equals(mode)) {
                return "https://www.mednet.swiss";
            }
            return "https://demo.mednet.swiss";
        }
        logger.error("Error when retrieving the base API URL from the preferences: {}");
        return "https://demo.mednet.swiss";
    }
}

