/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.util.FindingsServiceHolder;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.mednet.webapi.core.fhir.resources.util.FhirResourceFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Type;

public class RiskFactorResource {
    public static List<Observation> createRiskFactors(Reference patientReference, IPatient sourcePatient, FhirResourceFactory resourceFactory) {
        ArrayList<Observation> riskFactors = new ArrayList<Observation>();
        boolean structuredRiskCheck = ConfigServiceHolder.getGlobal((String)"riskfactor/settings/useStructured", (boolean)false);
        if (structuredRiskCheck) {
            List structuredRisks = FindingsServiceHolder.getiFindingsService().getPatientsFindings(sourcePatient.getId(), IObservation.class);
            List filteredRisks = structuredRisks.stream().filter(RiskFactorResource::isRisk).collect(Collectors.toList());
            for (IObservation structuredRisk : filteredRisks) {
                Observation riskFactor = resourceFactory.getResource(structuredRisk, IObservation.class, Observation.class);
                if (riskFactor == null) {
                    riskFactor = RiskFactorResource.createDefaultObservation(patientReference, sourcePatient.getRisk());
                }
                if (riskFactor.getId() == null || riskFactor.getId().isEmpty()) {
                    riskFactor.setId(UUID.randomUUID().toString());
                }
                RiskFactorResource.applyStandardCodes(riskFactor, patientReference, structuredRisk.getText().orElse("Unknown Risk"));
                riskFactors.add(riskFactor);
            }
        } else {
            String risk = sourcePatient.getRisk();
            if (risk != null && !risk.isEmpty()) {
                Observation riskFactor = RiskFactorResource.createDefaultObservation(patientReference, risk);
                riskFactors.add(riskFactor);
            }
        }
        return riskFactors;
    }

    private static Observation createDefaultObservation(Reference patientReference, String risk) {
        Observation riskFactor = new Observation();
        riskFactor.setId(UUID.randomUUID().toString());
        RiskFactorResource.applyStandardCodes(riskFactor, patientReference, risk);
        return riskFactor;
    }

    private static void applyStandardCodes(Observation riskFactor, Reference patientReference, String risk) {
        riskFactor.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-obs-riskFactor");
        riskFactor.setStatus(Observation.ObservationStatus.FINAL);
        riskFactor.setCategory(new ArrayList());
        riskFactor.addCategory(new CodeableConcept().addCoding(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/observation-category").setCode("social-history").setDisplay("Social History")));
        riskFactor.setCode(new CodeableConcept().addCoding(new Coding().setSystem("http://snomed.info/sct").setCode("80943009").setDisplay("Risk Factor")));
        String riskDisplay = risk == null ? "" : risk.trim();
        riskFactor.setValue((Type)new CodeableConcept().addCoding(new Coding().setSystem("http://snomed.info/sct").setCode("225338004").setDisplay("Risk assessment")).setText(riskDisplay));
        riskFactor.setSubject(patientReference);
    }

    private static boolean isRisk(IFinding iFinding) {
        if (iFinding instanceof IObservation && ((IObservation)iFinding).getCategory() == IObservation.ObservationCategory.SOCIALHISTORY) {
            for (ICoding code : ((IObservation)iFinding).getCoding()) {
                if (!IObservation.ObservationCode.ANAM_RISK.isSame(code)) continue;
                return true;
            }
        }
        return false;
    }
}

