/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources;

import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.util.FindingsServiceHolder;
import ch.elexis.core.model.IPatient;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;

public class ConditionResource {
    static void addConditionToBundle(Condition condition, List<Bundle.BundleEntryComponent> bundleEntries, List<Reference> conditionReferences) {
        if (condition != null) {
            String conditionFullUrl = "urn:uuid:" + condition.getId();
            Bundle.BundleEntryComponent conditionEntry = new Bundle.BundleEntryComponent();
            conditionEntry.setFullUrl(conditionFullUrl);
            conditionEntry.setResource((Resource)condition);
            bundleEntries.add(conditionEntry);
            conditionReferences.add(new Reference(conditionFullUrl));
        }
    }

    static List<ICondition> getLocalConditions(IPatient sourcePatient) {
        return FindingsServiceHolder.getiFindingsService().getPatientsFindings(sourcePatient.getId(), ICondition.class).stream().filter(finding -> finding instanceof ICondition).map(finding -> finding).collect(Collectors.toList());
    }

    public static List<Condition> createConditions(Patient patient, IPatient sourcePatient) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        String patientReference = "urn:uuid:" + patient.getId();
        String diagnosisString = sourcePatient.getDiagnosen();
        if (diagnosisString != null && !diagnosisString.isEmpty()) {
            String[] diagnosisArray;
            String[] stringArray = diagnosisArray = diagnosisString.split(",");
            int n = diagnosisArray.length;
            int n2 = 0;
            while (n2 < n) {
                String diagnosisText = stringArray[n2];
                diagnosisText = diagnosisText.trim();
                Condition condition = new Condition();
                condition.setId(UUID.randomUUID().toString());
                condition.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-condition");
                condition.setClinicalStatus(new CodeableConcept().addCoding(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/condition-clinical").setCode("active").setDisplay("Active")));
                condition.setSeverity(new CodeableConcept().addCoding(new Coding().setSystem("http://snomed.info/sct").setCode("255604002").setDisplay("Mild")));
                condition.setCode(new CodeableConcept().addCoding(new Coding().setSystem("http://snomed.info/sct").setCode("404684003").setDisplay("Clinical finding")).setText(diagnosisText));
                condition.setSubject(new Reference(patientReference));
                conditions.add(condition);
                ++n2;
            }
        }
        return conditions;
    }

    public static Condition createConditionFallback(ICondition localCondition, Patient patient) {
        Condition condition = new Condition();
        condition.setId(UUID.randomUUID().toString());
        condition.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-condition");
        condition.setClinicalStatus(new CodeableConcept().addCoding(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/condition-clinical").setCode("active").setDisplay("Active")));
        StringBuilder displayText = new StringBuilder();
        displayText.append(localCondition.getStatus() == ICondition.ConditionStatus.ACTIVE ? "Aktiv" : localCondition.getStatus().name()).append(" (").append(localCondition.getDateRecorded().orElse(LocalDate.now())).append(" ").append(localCondition.getStart().orElse("")).append(" - ").append(localCondition.getEnd().orElse("")).append(")").append(System.lineSeparator());
        Optional diagnosisText = localCondition.getText();
        displayText.append(diagnosisText.orElse("Unbekannte Diagnose")).append(System.lineSeparator());
        List notes = localCondition.getNotes();
        if (!notes.isEmpty()) {
            displayText.append("(Notizen: ").append(String.join((CharSequence)", ", notes)).append(")");
        }
        condition.setCode(new CodeableConcept().addCoding(new Coding().setSystem("http://snomed.info/sct").setCode("404684003").setDisplay("Clinical finding")).setText(displayText.toString()));
        condition.setSubject(new Reference("urn:uuid:" + patient.getId()));
        return condition;
    }
}

