/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.auth;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class GetAuthCodeWithStateSupplier
implements Supplier<String> {
    private String state;
    private static final int MAX_RETRIES = 5;
    private static final int RETRY_DELAY_MS = 2000;

    public GetAuthCodeWithStateSupplier(String state) {
        this.state = state;
    }

    @Override
    public String get() {
        String ret = null;
        int retries = 0;
        while (ret == null && retries < 5) {
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (InputStream input = new URL("https://tools.medelexis.ch/mednet/ac-obtain/" + URLEncoder.encode(this.state, "UTF-8")).openStream();){
                    String token = IOUtils.toString((InputStream)input, (String)"UTF-8");
                    if (StringUtils.isNotBlank((CharSequence)token)) {
                        ret = token;
                    } else {
                        LoggerFactory.getLogger(this.getClass()).warn("No authorization code for state: {}", (Object)this.state);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                try {
                    LoggerFactory.getLogger(this.getClass()).error("Error retrieving the authorization code from URL: https://tools.medelexis.ch/mednet/ac-obtain/" + URLEncoder.encode(this.state, "UTF-8"));
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
            }
            if (ret != null || ++retries >= 5) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (ret != null) {
            LoggerFactory.getLogger(this.getClass()).info("Authorization token successfully retrieved after {} retries.", (Object)retries);
        } else {
            LoggerFactory.getLogger(this.getClass()).error("Failed to retrieve an authorization token after {} retries.", (Object)retries);
        }
        return ret;
    }
}

