/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labororder.lg1_medicalvalues.order.model;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.labororder.lg1_medicalvalues.order.model.exceptions.NoEncounterSelectedException;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.utils.URIBuilder;

public class Patient {
    String aisIdentifier = "";
    String dateofbirth = "";
    String gender = "";
    String title = "";
    String lastname = "";
    String firstname = "";
    String street = "";
    String houseNumber = "";
    String zip = "";
    String city = "";
    String country = "";
    String telephoneNumberHome = "";
    String mobilePhoneNumber = "";
    String email = "";
    String insurancenumber = "";
    String insurancename = "";
    String insurancegln = "";
    String billing = "";
    String reason = "";
    String socialSecurityNumber = "";
    String physicianGlnNumber = "";
    private static Pattern pattern = Pattern.compile("^([A-Za-z-\u00df\\s]+)(\\d+)$");

    public static Patient of(IPatient patient) throws NoEncounterSelectedException {
        IXid physicianEAN;
        Optional mandator = ContextServiceHolder.get().getActiveMandator();
        IMandator activeMandator = null;
        if (mandator.isPresent()) {
            activeMandator = (IMandator)mandator.get();
        }
        Patient ret = new Patient();
        ret.aisIdentifier = patient.getPatientNr();
        ret.dateofbirth = patient.getDateOfBirth().format(DateTimeFormatter.ISO_LOCAL_DATE);
        ret.gender = patient.getGender() == Gender.FEMALE ? "female" : "male";
        ret.title = patient.getTitel();
        ret.lastname = patient.getLastName();
        ret.firstname = patient.getFirstName();
        String street = patient.getStreet().trim();
        try {
            Matcher matcher = pattern.matcher(street);
            matcher.find();
            ret.street = matcher.group(1).trim();
            ret.houseNumber = matcher.group(2).trim();
        }
        catch (Exception e) {
            ret.street = street;
            ret.houseNumber = "";
        }
        ret.zip = patient.getZip();
        ret.city = patient.getCity();
        ret.country = patient.getCountry().value();
        ret.telephoneNumberHome = patient.getPhone1();
        ret.mobilePhoneNumber = patient.getMobile();
        ret.email = patient.getEmail();
        Optional coverage = ContextServiceHolder.get().getActiveCoverage();
        ICoverage activeCoverage = null;
        if (!coverage.isPresent()) {
            throw new NoEncounterSelectedException();
        }
        activeCoverage = (ICoverage)coverage.get();
        ret.insurancenumber = activeCoverage.getInsuranceNumber();
        IContact costBearer = activeCoverage.getCostBearer();
        ret.insurancename = costBearer.getDescription1();
        IXid costBearerEAN = costBearer.getXid("www.xid.ch/id/ean");
        if (costBearerEAN != null) {
            ret.insurancegln = costBearerEAN.getDomainId();
        }
        ret.billing = Patient.getBilling(activeCoverage);
        ret.reason = Patient.getReason(activeCoverage);
        IXid patientAHV = patient.getXid("www.ahv.ch/xid");
        if (patientAHV != null) {
            ret.socialSecurityNumber = patientAHV.getDomainId();
        }
        if (activeMandator != null && (physicianEAN = activeMandator.getXid("www.xid.ch/id/ean")) != null) {
            ret.physicianGlnNumber = physicianEAN.getDomainId();
        }
        return ret;
    }

    public void toMedicalvaluesOrderCreationAPIQueryParams(URIBuilder builder) throws IllegalArgumentException {
        this.setOptionalParameter(builder, "physicianId", this.physicianGlnNumber);
        this.setOptionalParameter(builder, "source_system_name", "Elexis");
        this.setOptionalParameter(builder, "source_system_patient_id", this.aisIdentifier);
        this.setRequiredParameterOrThrow(builder, "patient_name_given", "Vorname", this.firstname);
        this.setRequiredParameterOrThrow(builder, "patient_name_family", "Nachname", this.lastname);
        this.setRequiredParameterOrThrow(builder, "patient_birthDate", "Geburtsdatum", this.dateofbirth);
        this.setRequiredParameterOrThrow(builder, "patient_gender", "Geschlecht", this.gender);
        this.setRequiredParameterOrThrow(builder, "coverage_type", "Abrechnungsart", this.billing);
        this.setOptionalParameter(builder, "patient_name_title", this.title);
        this.setOptionalParameter(builder, "patient_social_security_number", this.socialSecurityNumber);
        this.setOptionalParameter(builder, "patient_address_street", this.street);
        this.setOptionalParameter(builder, "patient_address_house_number", this.houseNumber);
        this.setOptionalParameter(builder, "patient_address_postal_code", this.zip);
        this.setOptionalParameter(builder, "patient_address_city", this.city);
        this.setOptionalParameter(builder, "patient_address_country", this.country);
        this.setOptionalParameter(builder, "patient_telecom_home", this.telephoneNumberHome);
        this.setOptionalParameter(builder, "patient_telecom_mobile", this.mobilePhoneNumber);
        this.setOptionalParameter(builder, "patient_email", this.email);
        this.setOptionalParameter(builder, "coverage_payor_display", this.insurancename);
        this.setOptionalParameter(builder, "coverage_payor_identifier", this.insurancegln);
        this.setOptionalParameter(builder, "coverage_identifier", this.insurancenumber);
        this.setOptionalParameter(builder, "order_treatment_type", this.reason);
    }

    private void setRequiredParameterOrThrow(URIBuilder builder, String key, String readableKey, String value) throws IllegalArgumentException {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(readableKey);
        }
        builder.setParameter(key, value);
    }

    private void setOptionalParameter(URIBuilder builder, String key, String value) {
        if (value != null && !value.isEmpty()) {
            builder.setParameter(key, value);
        }
    }

    private static String getBilling(ICoverage coverage) {
        BillingLaw billingLaw = coverage.getBillingSystem().getLaw();
        if (billingLaw == BillingLaw.VVG || billingLaw == BillingLaw.MV || billingLaw == BillingLaw.IV || billingLaw == BillingLaw.KVG) {
            return "SwissIns";
        }
        if (billingLaw == BillingLaw.UVG) {
            return "SwissAccidentInsurance";
        }
        if (billingLaw == BillingLaw.privat) {
            return "SEL";
        }
        return "SEL";
    }

    private static String getReason(ICoverage coverage) {
        String reason = coverage.getReason();
        if (Objects.equals(reason, "Krankheit")) {
            return "1";
        }
        if (Objects.equals(reason, "Mutterschaft")) {
            return "2";
        }
        if (Objects.equals(reason, "Unfall")) {
            return "3";
        }
        if (Objects.equals(reason, "Pr\u00e4vention")) {
            return "4";
        }
        return "";
    }
}

