/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labororder.lg1.order.model;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.types.Gender;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.labororder.lg1.messages.Messages;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Patient {
    String id = "";
    String dateofbirth = "";
    String gender = "";
    String title = "";
    String lastname = "";
    String firstname = "";
    String street = "";
    String zip = "";
    String city = "";
    String country = "";
    String insurancenumber = "";
    String insurancename = "";
    String insurancegln = "";
    String billing = "";

    public static Patient of(ch.elexis.data.Patient patient) {
        Patient ret = new Patient();
        ret.id = patient.getPatCode();
        ret.dateofbirth = new TimeTool(patient.getGeburtsdatum()).toString(9);
        ret.gender = patient.getGender() == Gender.FEMALE ? "female" : "male";
        ret.title = patient.get("Titel");
        ret.lastname = patient.getName();
        ret.firstname = patient.getVorname();
        ret.street = patient.getAnschrift().getStrasse();
        ret.zip = patient.getAnschrift().getPlz();
        ret.city = patient.getAnschrift().getOrt();
        ret.country = patient.getAnschrift().getLand();
        Fall fall = Patient.getFall(patient);
        if (fall == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabOrderAction_errorTitleNoFallSelected, (String)Messages.LabOrderAction_errorMessageNoFallSelected);
        }
        ret.insurancenumber = Patient.getInsuranceOrCaseNumber(fall);
        ret.insurancename = Patient.getInsuranceName(fall);
        ret.insurancegln = Patient.getInsuranceGln(fall);
        ret.billing = Patient.getBilling(fall);
        return ret;
    }

    private static String getBilling(Fall fall) {
        Kontakt costBearer = fall.getCostBearer();
        Kontakt guarantor = fall.getGarant();
        if (costBearer == null) {
            costBearer = fall.getGarant();
        }
        if (costBearer != null && costBearer.istOrganisation() && guarantor.equals((Object)costBearer)) {
            return "tp";
        }
        return "tg";
    }

    private static String getInsuranceName(Fall fall) {
        Kontakt costBearer = fall.getCostBearer();
        if (costBearer == null) {
            costBearer = fall.getGarant();
        }
        return costBearer.getLabel(true);
    }

    private static String getInsuranceGln(Fall fall) {
        Kontakt costBearer = fall.getCostBearer();
        if (costBearer == null) {
            costBearer = fall.getGarant();
        }
        return costBearer.getXid("www.xid.ch/id/ean");
    }

    private static Fall getFall(ch.elexis.data.Patient patient) {
        Fall fall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
        if (fall != null && fall.getPatient() != null && !patient.getId().equals(fall.getPatient().getId())) {
            fall = null;
        }
        if (fall == null) {
            ArrayList<Fall> offeneFaelleList = new ArrayList<Fall>();
            Fall[] fallArray = patient.getFaelle();
            int n = fallArray.length;
            int n2 = 0;
            while (n2 < n) {
                Fall tmpFall = fallArray[n2];
                if (tmpFall.isOpen()) {
                    offeneFaelleList.add(tmpFall);
                }
                ++n2;
            }
            if (offeneFaelleList.size() == 1) {
                fall = (Fall)offeneFaelleList.get(0);
            }
        }
        return fall;
    }

    private static String getInsuranceOrCaseNumber(Fall fall) {
        String nummer = null;
        BillingLaw gesetz = BillingLaw.KVG;
        try {
            gesetz = fall.getConfiguredBillingSystemLaw();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (gesetz != null) {
            nummer = gesetz == BillingLaw.IV ? fall.getRequiredString(TarmedRequirements.CASE_NUMBER) : (gesetz == BillingLaw.UVG ? fall.getRequiredString(TarmedRequirements.ACCIDENT_NUMBER) : fall.getRequiredString(TarmedRequirements.INSURANCE_NUMBER));
        }
        if (nummer == null) {
            nummer = fall.getInfoString(TarmedRequirements.CASE_NUMBER);
            if ("".equals(nummer)) {
                nummer = fall.getInfoString(TarmedRequirements.ACCIDENT_NUMBER);
            }
            if ("".equals(nummer)) {
                nummer = fall.getInfoString(TarmedRequirements.INSURANCE_NUMBER);
            }
        }
        return nummer;
    }
}

