/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.viollier.v2.data;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import java.util.List;

public class KontaktOrderManagement
extends PersistentObject {
    public static final String TABLENAME = "KONTAKT_ORDER_MANAGEMENT";
    public static final String ORDER_DOMAIN_LAB_ORDER_FILLER_MEDICS = "7601001383647";
    public static final String ORDER_DOMAIN_LAB_ORDER_FILLER_VIOLLIER = "7601002132732";
    public static final String FLD_KONTAKT_ID = "KONTAKT_ID";
    public static final String FLD_ORDER_NR = "ORDER_NR";
    public static final String FLD_ORDER_NR_DOMAIN = "ORDER_NR_DOMAIN";
    private static final String FLD_VERSION = "KONTAKT_ID";
    private static final String VERSION = "2";
    private static final String setVersionSQL = "UPDATE KONTAKT_ORDER_MANAGEMENT SET KONTAKT_ID='2' WHERE ID='VERSION'; ";
    private static final String index1SQL = "CREATE INDEX KONTAKT_ORDER_MANAGEMENT_idx_kontakt on KONTAKT_ORDER_MANAGEMENT(KONTAKT_ID);";
    private static final String index2SQL = "CREATE INDEX KONTAKT_ORDER_MANAGEMENT_idx1 on KONTAKT_ORDER_MANAGEMENT(KONTAKT_ID, ORDER_NR, ORDER_NR_DOMAIN);";
    private static final String index3SQL = "CREATE UNIQUE INDEX KONTAKT_ORDER_MANAGEMENT_idx_order on KONTAKT_ORDER_MANAGEMENT(ORDER_NR, ORDER_NR_DOMAIN);";
    private static final String addOrderNrDomain = "ALTER TABLE KONTAKT_ORDER_MANAGEMENT ADD ORDER_NR_DOMAIN VARCHAR(255);";
    private static final String createDB = "CREATE TABLE KONTAKT_ORDER_MANAGEMENT(ID VARCHAR(25) primary key,KONTAKT_ID VARCHAR(25),ORDER_NR VARCHAR(12),ORDER_NR_DOMAIN VARCHAR(255),lastupdate BIGINT,deleted CHAR(1) default '0');CREATE INDEX KONTAKT_ORDER_MANAGEMENT_idx_kontakt on KONTAKT_ORDER_MANAGEMENT(KONTAKT_ID);CREATE INDEX KONTAKT_ORDER_MANAGEMENT_idx1 on KONTAKT_ORDER_MANAGEMENT(KONTAKT_ID, ORDER_NR, ORDER_NR_DOMAIN);CREATE UNIQUE INDEX KONTAKT_ORDER_MANAGEMENT_idx_order on KONTAKT_ORDER_MANAGEMENT(ORDER_NR, ORDER_NR_DOMAIN);";
    private static final String insertVersion = "insert into KONTAKT_ORDER_MANAGEMENT (ID,KONTAKT_ID) VALUES ('VERSION', " + JdbcLink.wrap((String)"2") + ");";

    static {
        KontaktOrderManagement.addMapping((String)TABLENAME, (String[])new String[]{"KONTAKT_ID", FLD_ORDER_NR, FLD_ORDER_NR_DOMAIN});
        KontaktOrderManagement.checkTable();
    }

    private static void checkTable() {
        KontaktOrderManagement check = KontaktOrderManagement.load("VERSION");
        if (!check.exists()) {
            check = KontaktOrderManagement.checkVersion1();
        }
        if (!check.exists()) {
            KontaktOrderManagement.createOrModifyTable((String)(createDB + insertVersion));
        }
        try {
            int ver = Integer.parseInt(check.get("KONTAKT_ID"));
            switch (ver) {
                case 1: {
                    KontaktOrderManagement.updateToVersion2();
                    KontaktOrderManagement.createOrModifyTable((String)setVersionSQL);
                }
            }
            KontaktOrderManagement.checkInvalidEntries();
        }
        catch (Exception e) {
            SWTHelper.showError((String)"Error in Database", (String)String.format("Error in Table %s: No version information found", TABLENAME));
        }
    }

    private static void checkInvalidEntries() {
        try {
            Query query = new Query(KontaktOrderManagement.class);
            query.add(FLD_ORDER_NR_DOMAIN, "<>", ORDER_DOMAIN_LAB_ORDER_FILLER_MEDICS);
            query.and();
            query.add(FLD_ORDER_NR_DOMAIN, "<>", ORDER_DOMAIN_LAB_ORDER_FILLER_VIOLLIER);
            List list = query.execute();
            if (list.size() > 0) {
                SWTHelper.showError((String)"KontaktOrderManagement", (String)"Invalid Database Entries", (String)("Table KONTAKT_ORDER_MANAGEMENT contains " + Integer.toString(list.size()) + " entries of unknown order domains. Check your Database!"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static KontaktOrderManagement checkVersion1() {
        try {
            Query query = new Query(KontaktOrderManagement.class);
            query.add(FLD_ORDER_NR, ">", "");
            List list = query.execute();
            if (list.size() > 0) {
                KontaktOrderManagement.updateToVersion2();
                KontaktOrderManagement.createOrModifyTable((String)insertVersion);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return KontaktOrderManagement.load("VERSION");
    }

    private static void updateToVersion2() {
        KontaktOrderManagement.createOrModifyTable((String)addOrderNrDomain);
        KontaktOrderManagement.createOrModifyTable((String)index1SQL);
        KontaktOrderManagement.createOrModifyTable((String)index2SQL);
        KontaktOrderManagement.createOrModifyTable((String)index3SQL);
    }

    public KontaktOrderManagement(String kontaktID, String orderNrString, String orderNrDomain) {
        this.create(null);
        this.set(new String[]{"KONTAKT_ID", FLD_ORDER_NR, FLD_ORDER_NR_DOMAIN}, new String[]{kontaktID, orderNrString, orderNrDomain});
    }

    public KontaktOrderManagement(Kontakt kontakt, String orderNrString, String orderNrDomain) {
        this.create(null);
        this.set(new String[]{"KONTAKT_ID", FLD_ORDER_NR, FLD_ORDER_NR_DOMAIN}, new String[]{kontakt.getId(), orderNrString, orderNrDomain});
    }

    private KontaktOrderManagement(String id) {
        super(id);
    }

    public KontaktOrderManagement() {
    }

    public static KontaktOrderManagement load(String id) {
        return new KontaktOrderManagement(id);
    }

    public String getKontaktId() {
        return this.get("KONTAKT_ID");
    }

    public void setKontaktId(String value) {
        this.set("KONTAKT_ID", value);
    }

    public String getOrderNr() {
        return this.get(FLD_ORDER_NR);
    }

    public void setOrderNr(String value) {
        this.set(FLD_ORDER_NR, value);
    }

    public String getOrderNrDomain() {
        return this.get(FLD_ORDER_NR);
    }

    public void setOrderNrDomain(String value) {
        this.set(FLD_ORDER_NR_DOMAIN, value);
    }

    public String getLabel() {
        return this.getId();
    }

    protected String getTableName() {
        return TABLENAME;
    }
}

