/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labor.medics.v2.order;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.labor.medics.v2.order.PatientData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Response;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.LoggerFactory;

public class WebAis {
    private static String TESTURL = "https://test-order.medics.ch";
    private static String TESTAPITOKEN = "3YVRHY2AABF2GJTFBT2YY4KLHKTRJCSGXBGXGCIQRMZGCVWIWJSMIQYIHSWKIX4V";
    private static String PRODURL = "https://order.medics.ch";
    private static String PRODAPITOKEN = "JFG3ZSVLWVYZJ2N6U4ZT5P7ZDPJUQ4VC75UOMJKBTE5OGBYNKSFJK3CWAIW5KRQZ";
    private static String LOGIN = "/channel/authenticateExternal";
    private static String CREATEPATIENTANDORDER = "/channel/orderManagement/createPatientAndOrderExternal";
    private static final String CFG_MEDICS_BASE = "Medics_LaborOrder/";
    public static final String CFG_MEDICS_LABORDER_CUSTOMER = "Medics_LaborOrder/customer";
    public static final String CFG_MEDICS_LABORDER_USERNAME = "Medics_LaborOrder/username";
    public static final String CFG_MEDICS_LABORDER_PASSWORD = "Medics_LaborOrder/password";
    public static final String CFG_MEDICS_LABORDER_REQUESTER = "Medics_LaborOrder/requester";
    public static final String CFG_MEDICS_LABORDER_TESTMODE = "Medics_LaborOrder/testmode";
    private Client jaxrsClient;
    private Gson gson;

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().create();
        }
        return this.gson;
    }

    private Client getClient() {
        if (this.jaxrsClient == null) {
            this.jaxrsClient = this.createJaxrsClient();
        }
        return this.jaxrsClient;
    }

    private String getBaseUrl() {
        return ConfigServiceHolder.get().get(CFG_MEDICS_LABORDER_TESTMODE, false) ? TESTURL : PRODURL;
    }

    private String getApiToken() {
        return ConfigServiceHolder.get().get(CFG_MEDICS_LABORDER_TESTMODE, false) ? TESTAPITOKEN : PRODAPITOKEN;
    }

    private Client createJaxrsClient() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            return ClientBuilder.newBuilder().sslContext(sslcontext).hostnameVerifier((s1, s2) -> true).withConfig((Configuration)new ClientConfig()).build();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).warn("Error creating jaxrs client", (Throwable)e);
            return null;
        }
    }

    private String login(IMandator mandator) {
        WebTarget target = this.getClient().target(this.getBaseUrl()).path(LOGIN);
        if (WebAis.hasCredentials(mandator)) {
            String jsonString = this.getGson().toJson(this.getCredentials(mandator));
            Response response = target.request(new String[]{"application/json"}).header("APIToken", (Object)this.getApiToken()).post(Entity.json((Object)jsonString));
            if (response.getStatus() >= 300) {
                String message = target.toString() + " -> response status [" + response.getStatus() + "]\n" + (String)response.readEntity(String.class);
                LoggerFactory.getLogger(this.getClass()).error(message);
                throw new IllegalStateException("Login fehlgeschlagen");
            }
            Map responseMap = (Map)response.readEntity(Map.class);
            if (responseMap.get("isOK") instanceof Boolean && ((Boolean)responseMap.get("isOK")).booleanValue()) {
                return (String)responseMap.get("oneTimeToken");
            }
            return String.valueOf(responseMap.get("errorMessage")) + "\nCode: " + String.valueOf(responseMap.get("errorCode"));
        }
        throw new IllegalStateException("Mandant hat keinen Konfiguration f\u00fcr den Zugriff.\nBitte in den Einstellungen konfigurieren.");
    }

    public static boolean hasCredentials(IMandator mandator) {
        return StringUtils.isNotBlank((CharSequence)ConfigServiceHolder.get().get((IContact)mandator, CFG_MEDICS_LABORDER_USERNAME, null)) && StringUtils.isNotBlank((CharSequence)ConfigServiceHolder.get().get((IContact)mandator, CFG_MEDICS_LABORDER_PASSWORD, null)) && StringUtils.isNotBlank((CharSequence)ConfigServiceHolder.get().get((IContact)mandator, CFG_MEDICS_LABORDER_CUSTOMER, null));
    }

    private Map<String, String> getCredentials(IMandator mandator) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("username", ConfigServiceHolder.get().get((IContact)mandator, CFG_MEDICS_LABORDER_USERNAME, null));
        ret.put("password", ConfigServiceHolder.get().get((IContact)mandator, CFG_MEDICS_LABORDER_PASSWORD, null));
        ret.put("customer", ConfigServiceHolder.get().get((IContact)mandator, CFG_MEDICS_LABORDER_CUSTOMER, null));
        return ret;
    }

    private String getRequesterKey(IMandator mandator) {
        return ConfigServiceHolder.get().get((IContact)mandator, CFG_MEDICS_LABORDER_REQUESTER, null);
    }

    public String createPatientAndOrder(IPatient iPatient) {
        block6: {
            Optional mandator = ContextServiceHolder.get().getActiveMandator();
            if (mandator.isPresent()) {
                try {
                    String oneTimeToken = this.login((IMandator)mandator.get());
                    if (StringUtils.isNotBlank((CharSequence)oneTimeToken)) {
                        WebTarget target = this.getClient().target(this.getBaseUrl()).path(CREATEPATIENTANDORDER);
                        HashMap<String, Object> postContentMap = new HashMap<String, Object>();
                        postContentMap.put("patientData", PatientData.of(iPatient).withRequesterKey(this.getRequesterKey((IMandator)mandator.get())));
                        postContentMap.put("oneTimeToken", oneTimeToken);
                        String jsonString = this.getGson().toJson(postContentMap);
                        Response response = target.request(new String[]{"application/json"}).header("APIToken", (Object)this.getApiToken()).header("OneTimeToken", (Object)oneTimeToken).post(Entity.json((Object)jsonString));
                        if (response.getStatus() >= 300) {
                            String message = target.toString() + " -> response status [" + response.getStatus() + "]\n" + (String)response.readEntity(String.class);
                            LoggerFactory.getLogger(this.getClass()).error(message);
                            throw new IllegalStateException("Login fehlgeschlagen");
                        }
                        Map responseMap = (Map)response.readEntity(Map.class);
                        if (responseMap.get("url") instanceof String && StringUtils.isNotBlank((CharSequence)((String)responseMap.get("url")))) {
                            return this.getBaseUrl() + "/" + String.valueOf(responseMap.get("url"));
                        }
                        return (String)responseMap.get("errorMessage");
                    }
                    break block6;
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
            return "Kein aktiver Mandant";
        }
        return null;
    }
}

