/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labor.medics.v2.order;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.labor.medics.v2.MedicsActivator;
import ch.elexis.labor.medics.v2.Messages;
import ch.elexis.labor.medics.v2.order.LabOrderActionHl7;
import ch.elexis.labor.medics.v2.order.WebAis;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;

public class LabOrderAction
extends Action {
    private LabOrderActionHl7 labOrderHl7;

    public LabOrderAction() {
        this.setId("laborder");
        this.setImageDescriptor(MedicsActivator.getImageDescriptor("rsc/medics16.png"));
        this.setText(Messages.LabOrderAction_nameAction);
        this.labOrderHl7 = new LabOrderActionHl7();
    }

    public void run() {
        if (StringUtils.isEmpty((CharSequence)ConfigServiceHolder.get().get("medics/order_api", ""))) {
            this.labOrderHl7.run();
        } else {
            Optional patient = ContextServiceHolder.get().getActivePatient();
            if (patient.isPresent()) {
                WebAis webAis = new WebAis();
                String response = webAis.createPatientAndOrder((IPatient)patient.get());
                if (this.isUrl(response)) {
                    Program.launch((String)response);
                } else {
                    MessageDialog.openError((Shell)new Shell(), (String)Messages.LabOrderAction_errorTitleCannotShowURL, (String)response);
                }
            } else {
                MessageDialog.openError((Shell)new Shell(), (String)Messages.LabOrderAction_errorTitleNoPatientSelected, (String)Messages.LabOrderAction_errorMessageNoPatientSelected);
            }
        }
    }

    private boolean isUrl(String response) {
        return response != null && response.startsWith("http");
    }
}

