/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labor.medics.v2.labimport;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.importer.div.importers.DefaultPersistenceHandler;
import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.importer.div.importers.ILabContactResolver;
import ch.elexis.core.importer.div.importers.IPersistenceHandler;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.multifile.MultiFileParser;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.ui.importer.div.importers.DefaultLabContactResolver;
import ch.elexis.core.ui.importer.div.importers.DefaultLabImportUiHandler;
import ch.elexis.core.ui.importer.div.importers.ImporterPatientResolver;
import ch.elexis.core.ui.importer.div.importers.multifile.strategy.DefaultImportStrategyFactory;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.hl7.HL7PatientResolver;
import ch.elexis.labor.medics.v2.MedicsPreferencePage;
import ch.elexis.labor.medics.v2.Messages;
import ch.elexis.labor.medics.v2.labimport.PatientLabor;
import ch.elexis.labor.medics.v2.util.MedicsLogger;
import ch.elexis.laborimport.medics.v2.dbcheck.UpdateLabItemCode;
import ch.rgw.tools.Result;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LabOrderImport
extends ImporterPage {
    protected final SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private MultiFileParser mfParser = new MultiFileParser(PatientLabor.KUERZEL){

        protected IVirtualFilesystemService.IVirtualFilesystemHandle[] sortListHandles(IVirtualFilesystemService.IVirtualFilesystemHandle[] iVirtualFilesystemHandles) {
            Arrays.parallelSort(iVirtualFilesystemHandles, new Comparator<IVirtualFilesystemService.IVirtualFilesystemHandle>(){

                @Override
                public int compare(IVirtualFilesystemService.IVirtualFilesystemHandle left, IVirtualFilesystemService.IVirtualFilesystemHandle right) {
                    String[] leftParts = left.getName().split("_");
                    String[] rightParts = right.getName().split("_");
                    if (leftParts.length > 1 && StringUtils.isNotBlank((CharSequence)leftParts[1]) && rightParts.length > 1 && StringUtils.isNotBlank((CharSequence)rightParts[1])) {
                        return leftParts[1].compareTo(rightParts[1]);
                    }
                    return left.getName().compareTo(right.getName());
                }
            });
            return iVirtualFilesystemHandles;
        }
    };
    private HL7Parser hl7parser = new HL7Parser(PatientLabor.KUERZEL, (HL7PatientResolver)new ImporterPatientResolver(), (ImportHandler)new DefaultLabImportUiHandler(), (ILabContactResolver)new DefaultLabContactResolver(), CoreHub.localCfg.get("hl7Parser/importencdata", false));

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        MedicsLogger.getLogger().println(MessageFormat.format("{0}: Medics Laborimport gestartet", this.df.format(new Date())));
        MedicsLogger.getLogger().println("==============================================================");
        if (!UpdateLabItemCode.wasExecuted()) {
            UpdateLabItemCode.execute();
        }
        File downloadDir = new File(MedicsPreferencePage.getDownloadDir());
        Result result = null;
        MedicsLogger.getLogger().println(MessageFormat.format("HL7 Dateien in Verzeichnis {0} lesen..", downloadDir));
        if (downloadDir.isDirectory()) {
            result = this.mfParser.importFromDirectory(downloadDir, new DefaultImportStrategyFactory().setPDFImportCategory(MedicsPreferencePage.getDokumentKategorie()).setMoveAfterImport(true), this.hl7parser, (IPersistenceHandler)new DefaultPersistenceHandler());
        }
        MedicsLogger.getLogger().println(MessageFormat.format("{0}: Medics Laborimport beendet", this.df.format(new Date())));
        MedicsLogger.getLogger().println("");
        this.deleteOldArchivFiles();
        return ResultAdapter.getResultAsStatus((Result)result);
    }

    private void deleteOldArchivFiles() {
        int archivDeleted = 0;
        MedicsLogger.getLogger().println("Alte Archiv Dateien werden bereinigt..");
        int days = MedicsPreferencePage.getDeleteArchivDays();
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -days);
        long lastTime = cal.getTime().getTime();
        new File(MedicsPreferencePage.getDownloadDir());
        File downloadDir = new File(MedicsPreferencePage.getDownloadDir());
        File archiveDir = new File(downloadDir, "archive");
        if (archiveDir.exists() && archiveDir.isDirectory()) {
            File[] fileArray = archiveDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File archivFile = fileArray[n2];
                if (archivFile.lastModified() < lastTime && archivFile.delete()) {
                    ++archivDeleted;
                }
                ++n2;
            }
            MedicsLogger.getLogger().println(MessageFormat.format("{0} Dateien aus Archiv Verzeichnis gel\u00f6scht.", archivDeleted));
        }
        MedicsLogger.getLogger().println("");
    }

    public String getTitle() {
        return Messages.LabOrderImport_titleImport;
    }

    public String getDescription() {
        return Messages.LabOrderImport_descriptionImport;
    }

    public List<String> getObjectClass() {
        return Arrays.asList(ILabResult.class.getName(), "ch.elexis.omnivore.model.IDocumentHandle");
    }

    public Composite createPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblDownloadDir = new Label(composite, 0);
        lblDownloadDir.setText(Messages.LabOrderImport_labelDownloadDir);
        Text txtDownloadDir = new Text(composite, 2056);
        txtDownloadDir.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        String downloadDir = MedicsPreferencePage.getDownloadDir();
        if (downloadDir != null) {
            txtDownloadDir.setText(downloadDir);
        }
        Label lblKategorie = new Label(composite, 0);
        lblKategorie.setText(Messages.LabOrderImport_labelDocumentCategory);
        Text txtKategorie = new Text(composite, 2056);
        txtKategorie.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        String kategorie = MedicsPreferencePage.getDokumentKategorie();
        if (kategorie != null) {
            txtKategorie.setText(kategorie);
        }
        return composite;
    }
}

