/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.hl7.universal;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.importer.div.importers.DefaultPersistenceHandler;
import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.importer.div.importers.ILabContactResolver;
import ch.elexis.core.importer.div.importers.IPersistenceHandler;
import ch.elexis.core.importer.div.importers.multifile.MultiFileParser;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.importer.div.importers.DefaultHL7Parser;
import ch.elexis.core.ui.importer.div.importers.multifile.strategy.DefaultImportStrategyFactory;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.laborimport.hl7.universal.LinkLabContactResolver;
import ch.rgw.tools.Result;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

public class Importer
extends Action
implements IAction {
    public static final String MY_LAB = "Eigenlabor";
    private MultiFileParser mfParser = new MultiFileParser("Eigenlabor");
    private HL7Parser hlp = new DefaultHL7Parser("Eigenlabor");

    public Importer() {
        super("Hl7 Datei", Images.IMG_IMPORT.getImageDescriptor());
    }

    public void run() {
        if (CoreHub.localCfg.get("hl7/autoimport", false)) {
            MessageEvent.fireInformation((String)"HL7 Import", (String)"Automatischer Import ist aktiviert.");
            return;
        }
        File dir = new File(CoreHub.localCfg.get("hl7/downloaddir", File.separator));
        if (!dir.exists() || !dir.isDirectory()) {
            SWTHelper.showError((String)"bad directory for import", (String)"Konfigurationsfehler", (String)"Das Transferverzeichnis ist nicht korrekt eingestellt.");
        } else {
            int err = 0;
            int files = 0;
            Result r = null;
            Object[] fileNames = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String arg1) {
                    return arg1.toLowerCase().endsWith(".hl7");
                }
            });
            if (fileNames != null) {
                Arrays.sort(fileNames);
                Object[] objectArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    Object fn = objectArray[n2];
                    ++files;
                    File hl7file = new File(dir, (String)fn);
                    r = this.mfParser.importFromFile(hl7file, new DefaultImportStrategyFactory().setMoveAfterImport(true).setLabContactResolver((ILabContactResolver)new LinkLabContactResolver()), this.hlp, (IPersistenceHandler)new DefaultPersistenceHandler());
                    if (r != null && !r.isOK()) {
                        ++err;
                    }
                    ++n2;
                }
                if (err > 0) {
                    SWTHelper.showError((String)"HL7 Import Fehler", (String)(Integer.toString(err) + " von " + Integer.toString(files) + " Dateien hatten Fehler"));
                } else if (files == 0) {
                    SWTHelper.showInfo((String)"Laborimport", (String)"Es waren keine Dateien zum Import vorhanden");
                } else {
                    SWTHelper.showInfo((String)"Laborimport", (String)(Integer.toString(files) + " Dateien wurden fehlerfrei verarbeitet."));
                }
            } else {
                SWTHelper.showError((String)"bad directory for import", (String)"Konfigurationsfehler", (String)"Das Transferverzeichnis ist nicht korrekt eingestellt, bzw. kann nicht gelesen werden.");
            }
        }
    }
}

