/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.hl7.command;

import ch.elexis.core.importer.div.importers.multifile.strategy.FileImportStrategyUtil;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.tools.Result;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;

public class HL7FileArchiveHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String fileUrl = event.getParameter("ch.elexis.laborimport.hl7.allg.archiveFile.fileUrl").toString();
        if (fileUrl.isEmpty()) {
            throw new ExecutionException("File url parameter is empty");
        }
        IVirtualFilesystemService vfsService = OsgiServiceUtil.getService(IVirtualFilesystemService.class).orElse(null);
        if (vfsService == null) {
            throw new ExecutionException("VirtualFileSystemService is not available");
        }
        try {
            IVirtualFilesystemService.IVirtualFilesystemHandle vfsFile = vfsService.of(fileUrl);
            IVirtualFilesystemService.IVirtualFilesystemHandle fileHandleAfterMove = FileImportStrategyUtil.moveAfterImport((boolean)true, (IVirtualFilesystemService.IVirtualFilesystemHandle)vfsFile);
            Result result = Result.OK();
            result.addMessage(779, Result.SEVERITY.OK, "url", (Object)fileHandleAfterMove.getAbsolutePath());
            return result;
        }
        catch (IOException e) {
            throw new ExecutionException("Invalid fileUrl [" + fileUrl + "]", (Throwable)e);
        }
    }
}

