/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.kassenbuch;

import ch.elexis.buchhaltung.kassenbuch.KassenbuchEintrag;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BuchungsDialog
extends TitleAreaDialog {
    boolean bType;
    LabeledInputField liBeleg;
    LabeledInputField liBetrag;
    CDateTime liDate;
    Label dDate;
    Text text;
    KassenbuchEintrag act;
    KassenbuchEintrag lastNr;
    Combo cbDate;
    Combo cbCats;
    Combo cbPayments;

    BuchungsDialog(Shell shell, boolean mode) {
        super(shell);
        this.bType = mode;
        this.act = null;
    }

    BuchungsDialog(Shell shell, KassenbuchEintrag kbe) {
        super(shell);
        this.act = kbe;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout());
        Composite top = new Composite(ret, 2048);
        top.setLayout((Layout)new FillLayout());
        top.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.liBeleg = new LabeledInputField(top, "Beleg");
        Composite cbDate_1 = new Composite(top, 2048);
        cbDate_1.setLayout((Layout)new GridLayout(1, false));
        this.dDate = new Label(cbDate_1, 0);
        this.dDate.setText("Datum");
        this.liDate = new CDateTime(cbDate_1, 0x208802);
        this.liBetrag = new LabeledInputField(top, "Betrag", LabeledInputField.Typ.MONEY);
        Composite cCombos = new Composite(ret, 0);
        cCombos.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        cCombos.setLayout((Layout)new GridLayout(2, false));
        new Label(cCombos, 0).setText("Kategorie");
        this.cbCats = new Combo(cCombos, 4);
        this.cbCats.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cbCats.setItems(KassenbuchEintrag.getCategories());
        new Label(cCombos, 0).setText("Zahlungsart");
        this.cbPayments = new Combo(cCombos, 4);
        this.cbPayments.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cbPayments.setItems(KassenbuchEintrag.getPaymentModes());
        new Label(ret, 0).setText("Buchungstext");
        this.text = new Text(ret, 2048);
        this.text.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        if (this.act == null) {
            CompletableFuture.runAsync(() -> KassenbuchEintrag.recalc());
            this.lastNr = KassenbuchEintrag.lastNr();
            this.liBeleg.setText(KassenbuchEintrag.nextNr(this.lastNr));
        } else {
            this.liBeleg.setText(this.act.getBelegNr());
            this.liDate.setSelection(new TimeTool(this.act.getDate()).getTime());
            this.liBetrag.setText(this.act.getAmount().getAmountAsString());
            this.cbCats.setText(this.act.getKategorie());
            this.cbPayments.setText(this.act.getPaymentMode());
            this.text.setText(this.act.getText());
        }
        return ret;
    }

    public void create() {
        super.create();
        if (this.act == null) {
            if (this.bType) {
                this.setTitle("Einnahme verbuchen");
            } else {
                this.setTitle("Ausgabe verbuchen");
            }
        } else {
            this.setTitle("Buchung \u00e4ndern");
        }
        this.setMessage("Bitte geben Sie den Betrag und einen Buchungstext ein");
        this.getShell().setText("Buchung f\u00fcr Kassenbuch");
        this.liBetrag.getControl().setFocus();
    }

    protected void okPressed() {
        Money money = new Money();
        try {
            money.addAmount(this.liBetrag.getText());
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
        TimeTool tt = new TimeTool(this.liDate.getText());
        String bt = this.text.getText();
        if (this.act == null) {
            if (!this.bType) {
                money = money.negate();
            }
            this.act = new KassenbuchEintrag(this.liBeleg.getText(), tt.toString(4), money, bt, this.lastNr);
        } else {
            this.act.set(new String[]{"BelegNr", "Datum", "Betrag", "Text"}, new String[]{this.liBeleg.getText(), tt.toString(4), money.getCentsAsString(), this.text.getText()});
            KassenbuchEintrag.recalc();
        }
        this.act.setKategorie(this.cbCats.getText());
        this.act.setPaymentMode(this.cbPayments.getText());
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

