/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal;

import ch.elexis.data.Patient;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.LoggerFactory;

public class DiagDirectory
implements IAeskulapImportFile {
    private Map<String, File> diagMap = new HashMap<String, File>();
    private File file;

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public IAeskulapImportFile.Type getType() {
        return IAeskulapImportFile.Type.DIAGDIRECTORY;
    }

    @Override
    public boolean doImport(Map<IAeskulapImportFile.Type, IAeskulapImportFile> transientFiles, boolean overwrite, SubMonitor monitor) {
        monitor.beginTask("Aeskuplap Diagnosen Import", this.diagMap.size());
        for (String key : this.diagMap.keySet()) {
            File file = this.diagMap.get(key);
            if (file != null && file.isFile() && file.exists()) {
                this.readFile(file, Charset.forName("UTF-8")).ifPresent(content -> {
                    Patient patient = (Patient)this.getWithXid("elexis.ch/aeskulap_import/PatID", key);
                    if (patient != null) {
                        patient.setDiagnosen(content);
                    }
                });
            }
            monitor.worked(1);
        }
        monitor.done();
        return true;
    }

    private Optional<String> readFile(File file, Charset encoding) {
        try {
            byte[] encoded = Files.readAllBytes(file.toPath());
            if (encoded != null && encoded.length > 0) {
                return Optional.of(new String(encoded, encoding));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public Object getTransient(String filename) {
        return this.diagMap.get(filename);
    }

    public void add(File directory) {
        this.file = directory;
        File[] diagFiles = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("[0-9]+.txt");
            }
        });
        Arrays.asList(diagFiles).stream().forEach(f -> {
            File existing;
            if (f != null && (existing = this.diagMap.put(FilenameUtils.getBaseName((String)f.getName()), (File)f)) != null) {
                LoggerFactory.getLogger(this.getClass()).warn("Duplicate File [" + existing.getAbsolutePath() + "] [" + f.getAbsolutePath() + "]");
            }
        });
    }
}

