/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal.csv;

import ch.elexis.core.types.Gender;
import ch.elexis.data.Anschrift;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Organisation;
import ch.elexis.data.Person;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.core.internal.csv.AbstractCsvImportFile;
import com.opencsv.exceptions.CsvValidationException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.LoggerFactory;

public class AddressesFile
extends AbstractCsvImportFile<Kontakt>
implements IAeskulapImportFile {
    private File file;

    public AddressesFile(File file) {
        super(file);
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public static boolean canHandleFile(File file) {
        return FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase("csv") && FilenameUtils.getBaseName((String)file.getName()).equalsIgnoreCase("Adressen");
    }

    @Override
    public boolean isHeaderLine(String[] line) {
        return line.length > 1 && line[1] != null && line[1].equalsIgnoreCase("vorname");
    }

    @Override
    public Kontakt create(String[] line) {
        String firstname = line[1];
        String lastname = line[2];
        String department = line[3];
        if (StringUtils.isBlank((CharSequence)firstname) || StringUtils.isBlank((CharSequence)lastname)) {
            Object bez;
            Object object = bez = firstname == null ? "" : firstname;
            if (((String)bez).length() > 0) {
                bez = (String)bez + " ";
            }
            bez = (String)bez + lastname;
            return new Organisation((String)bez, department);
        }
        return new Person(lastname, firstname, "", Gender.UNKNOWN.value());
    }

    @Override
    public void setProperties(Kontakt contact, String[] line) {
        String street = StringUtils.isBlank((CharSequence)line[5]) ? line[4] : line[4] + ", " + line[5];
        Anschrift an = contact.getAnschrift();
        an.setStrasse(street);
        an.setPlz(line[6]);
        an.setOrt(line[7]);
        an.setLand(line[8]);
        contact.setAnschrift(an);
        contact.set("Kuerzel", line[9]);
        contact.set("Telefon1", line[16]);
        contact.set("Telefon2", line[15]);
        contact.set("NatelNr", line[14]);
        contact.set("Fax", line[17]);
        contact.set("E-Mail", line[18]);
        String ean = line[19];
        if (!StringUtils.isBlank((CharSequence)ean)) {
            contact.addXid("www.xid.ch/id/ean", ean, false);
        }
        contact.addXid(this.getXidDomain(), line[0], true);
    }

    @Override
    public boolean doImport(Map<IAeskulapImportFile.Type, IAeskulapImportFile> transientFiles, boolean overwrite, SubMonitor monitor) {
        monitor.beginTask("Aeskuplap Adressen Import", this.getLineCount());
        try {
            String[] line = null;
            while ((line = this.getNextLine()) != null) {
                Kontakt contact = (Kontakt)this.getExisting(line[0]);
                if (contact == null) {
                    contact = this.create(line);
                } else if (!overwrite) continue;
                this.setProperties(contact, line);
                monitor.worked(1);
            }
            return true;
        }
        catch (CsvValidationException | IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error importing file", e);
        }
        finally {
            this.close();
            monitor.done();
        }
        return false;
    }

    @Override
    public IAeskulapImportFile.Type getType() {
        return IAeskulapImportFile.Type.ADDRESSES;
    }

    @Override
    public String getXidDomain() {
        return "elexis.ch/aeskulap_import/AddrID";
    }
}

