/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal;

import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.LoggerFactory;

public class DocumentDirectories
implements IAeskulapImportFile {
    private Map<String, File> documentMap = new HashMap<String, File>();

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public IAeskulapImportFile.Type getType() {
        return IAeskulapImportFile.Type.DOCUMENTDIRECTORY;
    }

    @Override
    public boolean doImport(Map<IAeskulapImportFile.Type, IAeskulapImportFile> transientFiles, boolean overwrite, SubMonitor monitor) {
        return true;
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    public Object getTransient(String filename) {
        return this.documentMap.get(filename);
    }

    public void add(File directory) {
        File[] docFiles = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("Doc_") && name.contains("_");
            }
        });
        Arrays.asList(docFiles).stream().forEach(f -> {
            File existing;
            if (f != null && (existing = this.documentMap.put(FilenameUtils.getBaseName((String)f.getName()), (File)f)) != null) {
                LoggerFactory.getLogger(this.getClass()).warn("Duplicate File [" + existing.getAbsolutePath() + "] [" + f.getAbsolutePath() + "]");
            }
        });
    }
}

