/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal.csv;

import ch.elexis.core.types.LabItemTyp;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabMapping;
import ch.elexis.data.Labor;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.core.internal.csv.AbstractCsvImportFile;
import com.opencsv.exceptions.CsvValidationException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.LoggerFactory;

public class LabItemFile
extends AbstractCsvImportFile<LabItem>
implements IAeskulapImportFile {
    private File file;

    public LabItemFile(File file) {
        super(file);
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public static boolean canHandleFile(File file) {
        return FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase("csv") && FilenameUtils.getBaseName((String)file.getName()).equalsIgnoreCase("Labor_LabTyp");
    }

    @Override
    public IAeskulapImportFile.Type getType() {
        return IAeskulapImportFile.Type.LABORITEM;
    }

    @Override
    public boolean doImport(Map<IAeskulapImportFile.Type, IAeskulapImportFile> transientFiles, boolean overwrite, SubMonitor monitor) {
        monitor.beginTask("Aeskuplap Labor Parameter Import", this.getLineCount());
        try {
            String[] line = null;
            while ((line = this.getNextLine()) != null) {
                LabItem labItem = (LabItem)this.getExisting(line[0]);
                if (labItem == null) {
                    labItem = this.create(line);
                } else if (!overwrite) continue;
                this.setProperties(labItem, line);
            }
            return true;
        }
        catch (CsvValidationException | IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error importing file", e);
        }
        finally {
            this.close();
            monitor.done();
        }
        return false;
    }

    @Override
    public boolean isHeaderLine(String[] line) {
        return line[0].equalsIgnoreCase("LabTyp_no");
    }

    @Override
    public String getXidDomain() {
        return "elexis.ch/aeskulap_import/LabItemID";
    }

    @Override
    public LabItem create(String[] line) {
        String sequence = "?";
        if (!StringUtils.isBlank((CharSequence)line[6].trim())) {
            sequence = line[6].trim().substring(0, 1);
        }
        Labor laboratory = (Labor)this.getWithXid("elexis.ch/aeskulap_import/LabContactID", line[3]);
        LabItem labItem = new LabItem(line[7], line[6].trim(), (Kontakt)laboratory, null, null, line[4], LabItemTyp.TEXT, "Import", sequence);
        if (laboratory != null) {
            String labCode = "";
            if (!StringUtils.isBlank((CharSequence)line[5])) {
                labCode = line[5];
            } else if (!StringUtils.isBlank((CharSequence)line[7])) {
                labCode = line[7];
            }
            if (!StringUtils.isBlank((CharSequence)labCode)) {
                new LabMapping(laboratory.getId(), labCode, labItem.getId(), false);
            }
        }
        labItem.addXid(this.getXidDomain(), line[0], true);
        return labItem;
    }

    @Override
    public void setProperties(LabItem contact, String[] line) {
    }
}

