/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal.csv;

import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.Identifiable;
import ch.elexis.data.Patient;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.core.internal.csv.AbstractCsvImportFile;
import ch.elexis.importer.aeskulap.core.service.DocumentStoreServiceHolder;
import ch.rgw.tools.TimeTool;
import com.opencsv.exceptions.CsvValidationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.LoggerFactory;

public class FileFile
extends AbstractCsvImportFile<IDocument>
implements IAeskulapImportFile {
    public static final String CATEGORY_AESKULAP_DOKUMENTE = "Aeskulap-Dateien";
    private File file;
    private ICategory importCategory;
    private IAeskulapImportFile fileDirectory;

    public FileFile(File file) {
        super(file);
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public static boolean canHandleFile(File file) {
        return FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase("csv") && FilenameUtils.getBaseName((String)file.getName()).equalsIgnoreCase("Dateien");
    }

    @Override
    public IAeskulapImportFile.Type getType() {
        return IAeskulapImportFile.Type.FILE;
    }

    @Override
    public boolean doImport(Map<IAeskulapImportFile.Type, IAeskulapImportFile> transientFiles, boolean overwrite, SubMonitor monitor) {
        monitor.beginTask("Aeskuplap Dateien Import", this.getLineCount());
        this.importCategory = DocumentStoreServiceHolder.get().createCategory(CATEGORY_AESKULAP_DOKUMENTE);
        this.fileDirectory = transientFiles.get((Object)IAeskulapImportFile.Type.FILEDIRECTORY);
        if (this.fileDirectory != null) {
            try {
                String[] line = null;
                while ((line = this.getNextLine()) != null) {
                    String filename = this.getFilename(line);
                    this.file = (File)this.fileDirectory.getTransient(filename);
                    if (this.file != null) {
                        IDocument document = (IDocument)this.getExisting(line[1]);
                        if (document == null) {
                            document = this.create(line);
                        } else if (!overwrite) continue;
                        if (document != null) {
                            this.setProperties(document, line);
                            document.setExtension(FilenameUtils.getExtension((String)this.file.getName()));
                            document.setMimeType(FilenameUtils.getExtension((String)this.file.getName()));
                            Throwable throwable = null;
                            Object var8_11 = null;
                            try (FileInputStream fin = new FileInputStream(this.file);){
                                DocumentStoreServiceHolder.get().saveDocument(document, (InputStream)fin);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            String xid = line[1];
                            Optional po = DocumentStoreServiceHolder.get().getPersistenceObject(document);
                            if (po.isPresent()) {
                                if (po.get() instanceof IPersistentObject) {
                                    ((IPersistentObject)po.get()).addXid(this.getXidDomain(), xid, true);
                                } else if (po.get() instanceof Identifiable) {
                                    ((Identifiable)po.get()).addXid(this.getXidDomain(), xid, true);
                                }
                            }
                        }
                    }
                    monitor.worked(1);
                }
                return true;
            }
            catch (CsvValidationException | IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error importing file", e);
            }
            catch (ElexisException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error saving file", (Throwable)e);
            }
            finally {
                this.close();
                monitor.done();
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).error("No file directories found");
        }
        return false;
    }

    private String getFilename(String[] line) {
        return "PF_" + line[0] + "_" + line[1];
    }

    @Override
    public boolean isHeaderLine(String[] line) {
        return line[0].equalsIgnoreCase("pat_no");
    }

    @Override
    public String getXidDomain() {
        return "elexis.ch/aeskulap_import/FileID";
    }

    @Override
    public IDocument create(String[] line) {
        Patient patient = (Patient)this.getWithXid("elexis.ch/aeskulap_import/PatID", line[0]);
        if (patient != null) {
            IDocument document = DocumentStoreServiceHolder.get().createDocument(patient.getId(), line[4], this.importCategory.getName());
            return document;
        }
        return null;
    }

    @Override
    public void setProperties(IDocument document, String[] line) {
        TimeTool letterDate = new TimeTool(line[3]);
        document.setCreated(letterDate.getTime());
        document.setLastchanged(letterDate.getTime());
    }
}

