/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal.csv;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.types.Gender;
import ch.elexis.core.types.PathologicDescription;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabOrder;
import ch.elexis.data.LabResult;
import ch.elexis.data.Labor;
import ch.elexis.data.Patient;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.core.internal.csv.AbstractCsvImportFile;
import ch.rgw.tools.TimeTool;
import com.opencsv.exceptions.CsvValidationException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.LoggerFactory;

public class LabResultFile
extends AbstractCsvImportFile<LabResult>
implements IAeskulapImportFile {
    private File file;
    private Map<Patient, LabOrder> importOrderMap;

    public LabResultFile(File file) {
        super(file);
        this.file = file;
        this.importOrderMap = new HashMap<Patient, LabOrder>();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public static boolean canHandleFile(File file) {
        return FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase("csv") && FilenameUtils.getBaseName((String)file.getName()).equalsIgnoreCase("Labor_LabWert");
    }

    @Override
    public IAeskulapImportFile.Type getType() {
        return IAeskulapImportFile.Type.LABORRESULT;
    }

    @Override
    public boolean doImport(Map<IAeskulapImportFile.Type, IAeskulapImportFile> transientFiles, boolean overwrite, SubMonitor monitor) {
        monitor.beginTask("Aeskuplap Labor Resultate Import", this.getLineCount());
        try {
            String[] line = null;
            while ((line = this.getNextLine()) != null) {
                LabResult labResult = (LabResult)this.getExisting(line[0]);
                if (labResult == null) {
                    labResult = this.create(line);
                } else if (!overwrite) continue;
                this.setProperties(labResult, line);
            }
            return true;
        }
        catch (CsvValidationException | IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error importing file", e);
        }
        finally {
            this.close();
            monitor.done();
        }
        return false;
    }

    @Override
    public boolean isHeaderLine(String[] line) {
        return line[0].equalsIgnoreCase("Labwert_no");
    }

    @Override
    public String getXidDomain() {
        return "elexis.ch/aeskulap_import/LabResultID";
    }

    @Override
    public LabResult create(String[] line) {
        Patient patient = (Patient)this.getWithXid("elexis.ch/aeskulap_import/PatID", line[3]);
        LabItem item = (LabItem)this.getWithXid("elexis.ch/aeskulap_import/LabItemID", line[4]);
        if (patient == null || item == null) {
            LoggerFactory.getLogger(this.getClass()).error("Could not find patient_no (Patient) [" + line[3] + "] or typ_no (LabItem) [" + line[4] + "] for labresult_no [" + line[0] + "]");
            return null;
        }
        TimeTool date = new TimeTool(line[9]);
        LabResult labResult = new LabResult(patient, date, item, this.getResult(line), this.getComment(line));
        String orderId = "";
        LabOrder order = this.importOrderMap.get(patient);
        if (order == null) {
            orderId = LabOrder.getNextOrderId();
            order = new LabOrder(CoreHub.getLoggedInContact(), ElexisEventDispatcher.getSelectedMandator(), patient, item, labResult, orderId, "Aeskulap Import", new TimeTool());
            this.importOrderMap.put(patient, order);
        } else {
            orderId = order.get("orderid");
            order = new LabOrder(CoreHub.getLoggedInContact(), ElexisEventDispatcher.getSelectedMandator(), patient, item, labResult, orderId, "Aeskulap Import", new TimeTool());
        }
        if (order != null) {
            order.setState(LabOrder.State.DONE_IMPORT);
        }
        labResult.addXid(this.getXidDomain(), line[0], true);
        return labResult;
    }

    private String getComment(String[] line) {
        String resultString = this.getResultString(line);
        if (resultString.length() > 20) {
            return resultString + "\n\n" + this.normalizeTextValue(line[11]);
        }
        return this.normalizeTextValue(line[11]);
    }

    public String normalizeNumericValue(String value) {
        String stringValue = value.replaceAll(",", "\\.");
        try {
            Double numericValue = Double.parseDouble(stringValue);
            stringValue = Double.toString(numericValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return stringValue;
    }

    public String normalizeTextValue(String value) {
        return value.replaceAll("_x000D_", "");
    }

    private String getResultString(String[] line) {
        if (!StringUtils.isBlank((CharSequence)line[5])) {
            return this.normalizeTextValue(line[5]);
        }
        if (!StringUtils.isBlank((CharSequence)line[6])) {
            return this.normalizeNumericValue(line[6]);
        }
        return "";
    }

    private String getResult(String[] line) {
        String resultString = this.getResultString(line);
        if (resultString.length() > 20) {
            return "text";
        }
        return resultString;
    }

    @Override
    public void setProperties(LabResult labResult, String[] line) {
        if (labResult != null) {
            Labor laboratory = (Labor)this.getWithXid("elexis.ch/aeskulap_import/LabContactID", line[1]);
            if (laboratory != null) {
                labResult.set("OriginID", laboratory.getId());
            }
            if (!StringUtils.isBlank((CharSequence)line[10])) {
                TimeTool time = new TimeTool(line[10]);
                TimeTool observationTime = new TimeTool(line[9]);
                observationTime.setTime(time);
                labResult.setObservationTime(observationTime);
            }
            if (!StringUtils.isBlank((CharSequence)line[20])) {
                String refValue = line[20];
                if (this.isNumericRef(refValue)) {
                    if (refValue.startsWith("(")) {
                        refValue = refValue.substring(1);
                    }
                    if (refValue.endsWith(")")) {
                        refValue = refValue.substring(0, refValue.length() - 1);
                    }
                }
                if (labResult.getPatient().getGender() == Gender.MALE) {
                    labResult.setRefMale(refValue);
                } else {
                    labResult.setRefFemale(refValue);
                }
            }
            if (!StringUtils.isBlank((CharSequence)line[17])) {
                labResult.setFlag(1, true);
                labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_IMPORT, line[17]));
            } else {
                labResult.setFlag(1, false);
                labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_IMPORT));
            }
        }
    }

    private boolean isNumericRef(String refValue) {
        return refValue.matches("[\\.,<>+\\-0-9()]+");
    }
}

