/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.views;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.settings.UserSettings;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonContentProviderAdapter;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.icpc.Messages;
import ch.elexis.icpc.model.icpc.IcpcCode;
import ch.elexis.icpc.service.IcpcModelServiceHolder;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ChapterDisplay
extends Composite {
    private static final String UC2_HEADING = "ICPCChapter/";
    FormToolkit tk = UiDesk.getToolkit();
    ScrolledForm fLeft;
    String chapter;
    ExpandableComposite[] ec;
    Text tCrit;
    Text tIncl;
    Text tExcl;
    Text tNote;

    public ChapterDisplay(Composite parent, String chapter) {
        super(parent, 0);
        this.chapter = chapter;
        this.setLayout((Layout)new GridLayout(2, false));
        this.fLeft = this.tk.createScrolledForm((Composite)this);
        this.fLeft.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.fLeft.setText(chapter);
        Composite cLeft = this.fLeft.getBody();
        cLeft.setLayout((Layout)new GridLayout());
        cLeft.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        final Composite cRight = this.tk.createComposite((Composite)this);
        cRight.setLayout((Layout)new GridLayout());
        cRight.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.ec = new ExpandableComposite[Messages.components.length];
        int i = 0;
        while (i < this.ec.length) {
            String c = Messages.components[i];
            this.ec[i] = this.tk.createExpandableComposite(cLeft, 2);
            this.ec[i].setText(c);
            UserSettings.setExpandedState((ExpandableComposite)this.ec[i], (String)(UC2_HEADING + c.substring(0, 1)));
            Composite inlay = new Composite((Composite)this.ec[i], 0);
            inlay.setLayout((Layout)new FillLayout());
            CommonViewer cv = new CommonViewer();
            ViewerConfigurer vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)new ComponentContentProvider(c), (LabelProvider)new DefaultLabelProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(2, 4, cv));
            this.ec[i].setData((Object)cv);
            cv.create(vc, inlay, 0, (Object)this);
            vc.setDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ICodeSelectorTarget target;
                    if (event.getSelection() instanceof IStructuredSelection && !event.getSelection().isEmpty() && (target = CodeSelectorHandler.getInstance().getCodeSelectorTarget()) != null) {
                        target.codeSelected(((IStructuredSelection)event).getFirstElement());
                    }
                }
            });
            cv.getViewerWidget().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    if (!sel.isEmpty()) {
                        IcpcCode code = (IcpcCode)sel.getFirstElement();
                        ChapterDisplay.this.tCrit.setText(code.getCriteria());
                        ChapterDisplay.this.tIncl.setText(code.getInclusion());
                        ChapterDisplay.this.tExcl.setText(code.getExclusion());
                        ChapterDisplay.this.tNote.setText(code.getNote());
                        cRight.layout();
                    }
                }
            });
            this.ec[i].addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanging(ExpansionEvent e) {
                    ExpandableComposite src = (ExpandableComposite)e.getSource();
                    if (e.getState()) {
                        CommonViewer cv = (CommonViewer)src.getData();
                        cv.notify(CommonViewer.Message.update);
                    }
                    UserSettings.saveExpandedState((String)(ChapterDisplay.UC2_HEADING + src.getText().substring(0, 1)), (boolean)e.getState());
                }

                public void expansionStateChanged(ExpansionEvent e) {
                    ChapterDisplay.this.fLeft.reflow(true);
                }
            });
            this.ec[i].setClient((Control)inlay);
            ++i;
        }
        Section sCrit = this.tk.createSection(cRight, 64);
        sCrit.setText("Kriterien");
        this.tCrit = this.tk.createText((Composite)sCrit, "\n", 2050);
        sCrit.setClient((Control)this.tCrit);
        Section sIncl = this.tk.createSection(cRight, 64);
        sIncl.setText("Einschliesslich");
        this.tIncl = this.tk.createText((Composite)sIncl, "\n", 2050);
        sIncl.setClient((Control)this.tIncl);
        Section sExcl = this.tk.createSection(cRight, 64);
        sExcl.setText("Ausser");
        this.tExcl = this.tk.createText((Composite)sExcl, "", 2050);
        Section sNote = this.tk.createSection(cRight, 64);
        this.tNote = this.tk.createText(cRight, "\n", 2050);
        sNote.setText("Anmerkung");
    }

    public void setComponent(String mode) {
        int i = 0;
        while (i < this.ec.length) {
            this.ec[i].setEnabled(true);
            ++i;
        }
        if (!"RFE".equals(mode)) {
            if ("DG".equals(mode)) {
                i = 1;
                while (i < 6) {
                    this.ec[i].setEnabled(false);
                    this.ec[i].setExpanded(false);
                    ++i;
                }
            } else if ("PROC".equals(mode)) {
                this.ec[0].setEnabled(false);
                this.ec[0].setExpanded(false);
                this.ec[3].setEnabled(false);
                this.ec[3].setExpanded(false);
                this.ec[6].setEnabled(false);
                this.ec[6].setExpanded(false);
            }
        }
        this.fLeft.reflow(true);
    }

    class ComponentContentProvider
    extends CommonContentProviderAdapter {
        private String component;

        public ComponentContentProvider(String component) {
            this.component = component;
        }

        public Object[] getElements(Object inputElement) {
            return IcpcModelServiceHolder.loadAllFromComponent(ChapterDisplay.this.chapter, this.component, false).toArray();
        }
    }
}

