/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.service;

import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.icpc.model.icpc.IcpcCode;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class IcpcModelServiceHolder {
    private static IModelService modelService;

    @Reference(target="(service.model.name=ch.elexis.icpc.model)")
    public void setModelService(IModelService modelService) {
        IcpcModelServiceHolder.modelService = modelService;
    }

    public static IModelService get() {
        if (modelService == null) {
            throw new IllegalStateException("No IModelService available");
        }
        return modelService;
    }

    public static List<IcpcCode> loadAllFromComponent(String chapter, String component, boolean order) {
        IQuery query = IcpcModelServiceHolder.get().getQuery(IcpcCode.class);
        query.and("component", IQuery.COMPARATOR.EQUALS, (Object)component.substring(0, 1));
        query.startGroup();
        query.and("ID", IQuery.COMPARATOR.LIKE, (Object)"*%");
        query.or("ID", IQuery.COMPARATOR.LIKE, (Object)(chapter.substring(0, 1) + "%"));
        query.andJoinGroups();
        query.orderBy("ID", order ? IQuery.ORDER.ASC : IQuery.ORDER.DESC);
        return query.execute();
    }
}

