/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc;

import ch.elexis.core.model.IDiagnosisTree;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.icpc.model.icpc.IcpcCode;
import ch.elexis.icpc.service.CodeElementServiceHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class CodeSelectorFactory
extends ch.elexis.core.ui.views.codesystems.CodeSelectorFactory {
    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        ViewerConfigurer vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)new IcpcCodeContentProvider(cv), (LabelProvider)new IcpcCodeLabelProvider(), (ViewerConfigurer.ControlFieldProvider)new DefaultControlFieldProvider(cv, new String[]{"Text"}), (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(0, 0, null));
        vc.setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
        cv.setNamedSelection("ch.elexis.icpc.selection");
        return vc;
    }

    public void dispose() {
    }

    public String getCodeSystemName() {
        return "ICPC";
    }

    public Class getElementClass() {
        return IcpcCode.class;
    }

    public class IcpcCodeContentProvider
    implements ViewerConfigurer.ICommonViewerContentProvider,
    ITreeContentProvider {
        private CommonViewer viewer;
        private String filterValue;

        public IcpcCodeContentProvider(CommonViewer cv) {
            this.viewer = cv;
        }

        public void startListening() {
            this.viewer.getConfigurer().getControlFieldProvider().addChangeListener((ViewerConfigurer.ControlFieldListener)this);
        }

        public void stopListening() {
            this.viewer.getConfigurer().getControlFieldProvider().removeChangeListener((ViewerConfigurer.ControlFieldListener)this);
        }

        public Object[] getElements(Object inputElement) {
            ICodeElementServiceContribution icpcCodeElementContribution = (ICodeElementServiceContribution)CodeElementServiceHolder.get().getContribution(ICodeElementService.CodeElementTyp.DIAGNOSE, "ICPC").orElseThrow(() -> new IllegalStateException("No ICPC CodeElementContribution available"));
            List roots = icpcCodeElementContribution.getElements(Collections.singletonMap(ICodeElementService.ContextKeys.TREE_ROOTS, Boolean.TRUE));
            return roots.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void changed(HashMap<String, String> values) {
            String filterText = values.get("Text").toLowerCase();
            if (filterText == null || filterText.isEmpty() || filterText.equals("%")) {
                this.setFilterValue("");
            } else {
                this.setFilterValue(filterText);
            }
            this.viewer.notify(CommonViewer.Message.update);
            if (StringUtils.isNotBlank((CharSequence)this.filterValue)) {
                ((TreeViewer)this.viewer.getViewerWidget()).expandAll();
            }
        }

        public boolean matchFilter(IDiagnosisTree element) {
            if (StringUtils.isNotBlank((CharSequence)this.filterValue)) {
                if (element.getChildren().isEmpty()) {
                    return (element.getCode() + " " + element.getText()).toLowerCase().contains(this.filterValue);
                }
                return this.getChildren(element).length > 0;
            }
            return true;
        }

        public void reorder(String field) {
        }

        public void selected() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IDiagnosisTree) {
                if (StringUtils.isBlank((CharSequence)this.filterValue)) {
                    return ((IDiagnosisTree)parentElement).getChildren().toArray();
                }
                List availableChildren = ((IDiagnosisTree)parentElement).getChildren().parallelStream().filter(ti -> this.matchFilter((IDiagnosisTree)ti)).collect(Collectors.toList());
                return availableChildren.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IDiagnosisTree) {
                return ((IDiagnosisTree)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IDiagnosisTree) {
                if (StringUtils.isBlank((CharSequence)this.filterValue)) {
                    List children = ((IDiagnosisTree)element).getChildren();
                    return children != null && !children.isEmpty();
                }
                return this.getChildren(element).length > 0;
            }
            return false;
        }

        public void init() {
        }

        private void setFilterValue(String value) {
            this.filterValue = value;
        }
    }

    public class IcpcCodeLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof IDiagnosisTree) {
                return ((IDiagnosisTree)element).getLabel();
            }
            return super.getText(element);
        }
    }
}

