/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.views;

import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.icpc.model.icpc.IcpcCode;
import ch.elexis.icpc.service.IcpcModelServiceHolder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ShortlistComposite
extends Composite {
    private String[] SHORTLIST_CODES = new String[]{"K86", "K74", "K75", "K77", "T90", "R95", "K78", "K90", "K92", "P17", "R96", "P70", "A96"};

    public ShortlistComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        List shortList = Arrays.asList(this.SHORTLIST_CODES).stream().map(s -> (IcpcCode)IcpcModelServiceHolder.get().load(s, IcpcCode.class).get()).collect(Collectors.toList());
        final ListViewer listViewer = new ListViewer((Composite)this, 2560);
        org.eclipse.swt.widgets.List list = listViewer.getList();
        DragSource dragSource = new DragSource((Control)list, 1);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection ss = listViewer.getStructuredSelection();
                if (ss.isEmpty()) {
                    event.data = null;
                    event.doit = false;
                } else {
                    event.data = (IcpcCode)ss.getFirstElement();
                }
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection ss = listViewer.getStructuredSelection();
                if (!ss.isEmpty()) {
                    event.data = StoreToStringServiceHolder.get().storeToString((Identifiable)((IcpcCode)ss.getFirstElement())).orElse(null);
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        listViewer.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider());
        listViewer.setInput(shortList);
    }
}

