/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.model.internal.service;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.ICPCCode;
import ch.elexis.core.jpa.entities.ICPCEncounter;
import ch.elexis.core.jpa.entities.ICPCEpisode;
import ch.elexis.core.jpa.model.adapter.AbstractModelAdapterFactory;
import ch.elexis.core.jpa.model.adapter.MappingEntry;
import ch.elexis.icpc.model.icpc.IcpcCode;
import ch.elexis.icpc.model.icpc.IcpcEncounter;
import ch.elexis.icpc.model.icpc.IcpcEpisode;
import ch.elexis.icpc.model.internal.Code;
import ch.elexis.icpc.model.internal.Encounter;
import ch.elexis.icpc.model.internal.Episode;
import java.util.Optional;

public class IcpcModelAdapterFactory
extends AbstractModelAdapterFactory {
    private static IcpcModelAdapterFactory INSTANCE;

    public static synchronized IcpcModelAdapterFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IcpcModelAdapterFactory();
        }
        return INSTANCE;
    }

    private IcpcModelAdapterFactory() {
    }

    protected void initializeMappings() {
        this.addMapping(new MappingEntry(IcpcCode.class, Code.class, ICPCCode.class));
        this.addMapping(new MappingEntry(IcpcEpisode.class, Episode.class, ICPCEpisode.class));
        this.addMapping(new MappingEntry(IcpcEncounter.class, Encounter.class, ICPCEncounter.class));
    }

    public <T> T getAdapter(EntityWithId entity, Class<T> clazz, boolean registerEntityChangeEvent) {
        if (entity != null) {
            Optional adapter = IcpcModelAdapterFactory.getInstance().getModelAdapter(entity, clazz, true, registerEntityChangeEvent);
            return adapter.orElse(null);
        }
        return null;
    }
}

