/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.message.ui.preference;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.hl7.message.ui.preference.Receiver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class PreferenceUtil {
    public static final String PREF_RECEIVERS = "ch.elexis.hl7.message.ui/receivers";
    public static final String PREF_FILESYSTEM_OUTPUTDIR = "ch.elexis.hl7.message.ui/output/directory";

    public static List<Receiver> getReceivers() {
        String[] receiversParts;
        ArrayList<Receiver> ret = new ArrayList<Receiver>();
        String receiversString = ConfigServiceHolder.getGlobal((String)PREF_RECEIVERS, null);
        if (receiversString != null && !receiversString.isEmpty() && (receiversParts = receiversString.split("\\|\\|")) != null) {
            String[] stringArray = receiversParts;
            int n = receiversParts.length;
            int n2 = 0;
            while (n2 < n) {
                String receiverString = stringArray[n2];
                ret.add(Receiver.of(receiverString));
                ++n2;
            }
        }
        return ret;
    }

    public static void addReceiver(Receiver receiver) {
        List<Receiver> receivers = PreferenceUtil.getReceivers();
        receivers.add(receiver);
        PreferenceUtil.setReceivers(receivers);
    }

    public static void removeReceiver(Receiver receiver) {
        List<Receiver> receivers = PreferenceUtil.getReceivers();
        List<Receiver> filtered = receivers.stream().filter(existing -> !existing.equals(receiver)).collect(Collectors.toList());
        PreferenceUtil.setReceivers(filtered);
    }

    public static void setReceivers(List<Receiver> receivers) {
        StringJoiner sj = new StringJoiner("||");
        for (Receiver receiver : receivers) {
            sj.add(receiver.toString());
        }
        ConfigServiceHolder.setGlobal((String)PREF_RECEIVERS, (String)sj.toString());
    }

    public static Optional<File> getOutputDirectory() {
        String outputDir = CoreHub.localCfg.get(PREF_FILESYSTEM_OUTPUTDIR, null);
        if (outputDir != null) {
            return Optional.of(new File(outputDir));
        }
        return Optional.empty();
    }
}

