/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.message.ui.preference;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.hl7.message.ui.preference.PreferenceUtil;
import ch.elexis.hl7.message.ui.preference.Receiver;
import ch.elexis.hl7.message.ui.preference.ReceiverEditDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MessagePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer receiverViewer;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new DirectoryFieldEditor("ch.elexis.hl7.message.ui/output/directory", "Ausgabe Verzeichnis", this.getFieldEditorParent()));
        Composite area = new Composite(this.getFieldEditorParent().getParent(), 0);
        area.setLayoutData((Object)new GridData(1808));
        area.setLayout((Layout)new GridLayout(1, false));
        Label lbl = new Label(area, 0);
        lbl.setText("Empf\u00e4nger Konfiguration");
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBarManager toolbar = new ToolBarManager();
        toolbar.add((IAction)new AddReceiverAction());
        toolbar.add((IAction)new RemoveReceiverAction());
        ToolBar toolbarControl = toolbar.createControl(area);
        toolbarControl.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.receiverViewer = new TableViewer(area, 2048);
        this.receiverViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.receiverViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Receiver) {
                    return ((Receiver)element).getApplication() + " - " + ((Receiver)element).getFacility();
                }
                return super.getText(element);
            }
        });
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 100;
        this.receiverViewer.getTable().setLayoutData((Object)gd);
        this.receiverViewer.setInput(PreferenceUtil.getReceivers());
    }

    private class AddReceiverAction
    extends Action {
        private AddReceiverAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_NEW.getImageDescriptor();
        }

        public void run() {
            Receiver receiver = new Receiver();
            ReceiverEditDialog dialog = new ReceiverEditDialog(MessagePreferencePage.this.getShell());
            dialog.setReceiver(receiver);
            if (dialog.open() == 0) {
                PreferenceUtil.addReceiver(receiver);
                MessagePreferencePage.this.receiverViewer.setInput(PreferenceUtil.getReceivers());
            }
        }
    }

    private class RemoveReceiverAction
    extends Action {
        private RemoveReceiverAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_DELETE.getImageDescriptor();
        }

        public void run() {
            IStructuredSelection selection = MessagePreferencePage.this.receiverViewer.getStructuredSelection();
            if (selection != null && !selection.isEmpty()) {
                Receiver selected = (Receiver)selection.getFirstElement();
                PreferenceUtil.removeReceiver(selected);
                MessagePreferencePage.this.receiverViewer.setInput(PreferenceUtil.getReceivers());
            }
        }
    }
}

