/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.message.core.service;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.hl7.message.core.IHL7MessageService;
import ch.elexis.hl7.message.core.message.ADT_A08Message;
import ch.elexis.hl7.message.core.message.IHL7Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class HL7MessageService
implements IHL7MessageService {
    private Map<String, List<IHL7Message>> messages = new HashMap<String, List<IHL7Message>>();

    public HL7MessageService() {
        this.addMessage("ADT_A08", new ADT_A08Message());
    }

    private void addMessage(String messageTyp, IHL7Message message) {
        List<IHL7Message> messagesList = this.messages.get(messageTyp);
        if (messagesList == null) {
            messagesList = new ArrayList<IHL7Message>();
        }
        messagesList.add(message);
        this.messages.put(messageTyp, messagesList);
    }

    @Override
    public List<String> validateContext(String messageTyp, Map<String, Object> context) throws ElexisException {
        List<IHL7Message> messageVersions = this.messages.get(messageTyp);
        if (messageVersions != null && !messageVersions.isEmpty()) {
            String versionHint = (String)context.get("context.hl7version");
            if (versionHint != null) {
                for (IHL7Message ihl7Message : messageVersions) {
                    if (!versionHint.equals(ihl7Message.getHL7Version())) continue;
                    return ihl7Message.validateContext(context);
                }
            }
            return messageVersions.get(0).validateContext(context);
        }
        throw new ElexisException("No message implementation for typ [" + messageTyp + "]");
    }

    @Override
    public String getMessage(String messageTyp, Map<String, Object> context) throws ElexisException {
        List<IHL7Message> messageVersions = this.messages.get(messageTyp);
        if (messageVersions != null && !messageVersions.isEmpty()) {
            String versionHint = (String)context.get("context.hl7version");
            if (versionHint != null) {
                for (IHL7Message ihl7Message : messageVersions) {
                    if (!versionHint.equals(ihl7Message.getHL7Version())) continue;
                    return ihl7Message.getMessage(context);
                }
            }
            return messageVersions.get(0).getMessage(context);
        }
        throw new ElexisException("No message implementation for typ [" + messageTyp + "]");
    }
}

