/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.ui.e4.dialog.VirtualFilesystemUriEditorDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.global_inbox.core.handler.TaskManagerHandler;
import ch.elexis.global_inbox.ui.Messages;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.elexis.omnivore.model.TransientCategory;
import ch.elexis.omnivore.model.util.CategoryUtil;
import ch.elexis.omnivore.ui.util.CategorySelectDialog;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

public class PreferencesServer
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text newDeviceText;
    private Text deviceDirText;
    private Combo deviceCombo;
    private Map<String, String> deviceDirMap = new HashMap<String, String>();
    private Composite mainComposite;
    private String lastSelectedCategory;
    private ListViewer categoryListViewer;
    private Combo patientSourceCombo;
    @Reference
    private ITaskService taskService;
    private TaskManagerHandler taskManagerHandler;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
        this.taskService = OsgiServiceUtil.getService(ITaskService.class).orElse(null);
        this.taskManagerHandler = new TaskManagerHandler(this.taskService);
        this.lastSelectedCategory = ConfigServiceHolder.getGlobal((String)"plugins/global_inbox_server/last_selected_category", (String)"");
    }

    public PreferencesServer() {
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
    }

    protected Control createContents(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        Composite storeFSGlobalComposite = new Composite(this.mainComposite, 0);
        storeFSGlobalComposite.setLayout((Layout)new GridLayout(1, false));
        storeFSGlobalComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Button storeFSGlobalButton = new Button(storeFSGlobalComposite, 32);
        storeFSGlobalButton.setText(Messages.PreferencesServer_storeFSGlobal);
        storeFSGlobalButton.setSelection(ConfigServiceHolder.getGlobal((String)"plugins/global_inbox_server/store_in_fs_global", (boolean)false));
        storeFSGlobalButton.addListener(13, e -> {
            boolean bl = ConfigServiceHolder.get().set("plugins/global_inbox_server/store_in_fs_global", storeFSGlobalButton.getSelection());
        });
        Composite contentComposite = new Composite(this.mainComposite, 0);
        contentComposite.setLayout((Layout)new GridLayout(3, false));
        contentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        int labelWidth = 150;
        Label deviceLabel = new Label(contentComposite, 0);
        deviceLabel.setText(Messages.PreferencesServer_addNewDevice);
        GridData deviceLabelGridData = new GridData(131072, 0x1000000, false, false);
        deviceLabelGridData.widthHint = labelWidth;
        deviceLabel.setLayoutData((Object)deviceLabelGridData);
        this.newDeviceText = new Text(contentComposite, 2048);
        GridData newDeviceTextGridData = new GridData(4, 0x1000000, true, false);
        this.newDeviceText.setLayoutData((Object)newDeviceTextGridData);
        Button addButton = new Button(contentComposite, 8);
        addButton.setImage(Images.IMG_NEW.getImage());
        addButton.setText(Messages.Core_Add);
        addButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        addButton.addListener(13, e -> {
            this.addNewDevice(this.newDeviceText.getText(), contentComposite);
            this.newDeviceText.setText("");
        });
        Label comboLabel = new Label(contentComposite, 0);
        comboLabel.setText(Messages.PreferencesServer_selectDevice);
        GridData comboLabelGridData = new GridData(131072, 0x1000000, false, false);
        comboLabelGridData.widthHint = labelWidth;
        comboLabel.setLayoutData((Object)comboLabelGridData);
        this.deviceCombo = new Combo(contentComposite, 12);
        GridData deviceComboGridData = new GridData(4, 0x1000000, true, false);
        this.deviceCombo.setLayoutData((Object)deviceComboGridData);
        this.deviceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesServer.this.updateDeviceFields();
            }
        });
        Button deleteButton = new Button(contentComposite, 8);
        deleteButton.setImage(Images.IMG_DELETE.getImage());
        deleteButton.setText(Messages.PreferencesServer_deleteButton);
        deleteButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        deleteButton.addListener(13, e -> this.deleteSelectedDevice(this.deviceCombo.getText(), contentComposite));
        Label dirLabel = new Label(contentComposite, 0);
        dirLabel.setText(Messages.InboxView_inbox);
        GridData dirLabelGridData = new GridData(131072, 0x1000000, false, false);
        dirLabelGridData.widthHint = labelWidth;
        dirLabel.setLayoutData((Object)dirLabelGridData);
        this.deviceDirText = new Text(contentComposite, 2048);
        GridData deviceDirTextGridData = new GridData(4, 0x1000000, true, false);
        deviceDirTextGridData.widthHint = 300;
        this.deviceDirText.setLayoutData((Object)deviceDirTextGridData);
        this.deviceDirText.setEnabled(false);
        Button browseButton = new Button(contentComposite, 8);
        browseButton.setText(Messages.PreferencesServer_browseButton);
        browseButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        browseButton.addListener(13, e -> {
            VirtualFilesystemUriEditorDialog dialog;
            int result;
            IVirtualFilesystemService virtualFilesystemService = VirtualFilesystemServiceHolder.get();
            URI inputUri = null;
            try {
                String currentDir = this.deviceDirText.getText();
                if (StringUtils.isNotBlank((CharSequence)currentDir)) {
                    IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle = virtualFilesystemService.of(currentDir, false);
                    inputUri = fileHandle.toURL().toURI();
                }
            }
            catch (IOException | URISyntaxException ex) {
                LoggerFactory.getLogger(PreferencesServer.class).error("Error converting URL to URI", (Throwable)ex);
            }
            if ((result = (dialog = new VirtualFilesystemUriEditorDialog(this.getShell(), virtualFilesystemService, inputUri)).open()) == 0) {
                String selectedUri = dialog.getValue().toString();
                this.deviceDirText.setText(selectedUri);
            }
        });
        new Label(contentComposite, 0);
        Label omnivoreDirLabel = new Label(contentComposite, 0);
        omnivoreDirLabel.setText(Messages.PreferencesServer_omnivoreDirStructure);
        GridData omnivoreDirLabelGridData = new GridData(16384, 0x1000000, false, false, 3, 1);
        omnivoreDirLabel.setLayoutData((Object)omnivoreDirLabelGridData);
        Composite categoryComposite = new Composite(contentComposite, 0);
        GridLayout categoryLayout = new GridLayout(2, false);
        categoryLayout.marginWidth = 0;
        categoryLayout.marginHeight = 0;
        categoryComposite.setLayout((Layout)categoryLayout);
        GridData categoryCompositeGridData = new GridData(16384, 128, false, false, 3, 1);
        categoryCompositeGridData.widthHint = 250;
        categoryComposite.setLayoutData((Object)categoryCompositeGridData);
        this.categoryListViewer = new ListViewer(categoryComposite, 2564);
        GridData listViewerGridData = new GridData(16384, 128, false, false);
        listViewerGridData.widthHint = 150;
        listViewerGridData.heightHint = 200;
        this.categoryListViewer.getList().setLayoutData((Object)listViewerGridData);
        this.categoryListViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.categoryListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.categoryListViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = this.categoryListViewer.getStructuredSelection();
            String selectedCategory = (String)selection.getFirstElement();
            if (selectedCategory != null) {
                this.lastSelectedCategory = selectedCategory;
                ConfigServiceHolder.get().set("plugins/global_inbox_server/last_selected_category", this.lastSelectedCategory);
            }
        });
        Composite buttonComposite = new Composite(categoryComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        GridData buttonCompositeGridData = new GridData(16384, 128, false, false);
        buttonCompositeGridData.widthHint = 50;
        buttonComposite.setLayoutData((Object)buttonCompositeGridData);
        Button bNewCat = new Button(buttonComposite, 8);
        bNewCat.setImage(Images.IMG_NEW.getImage());
        bNewCat.setToolTipText(Messages.PreferencesServer_addNewDirectory);
        bNewCat.setLayoutData((Object)new GridData(4, 128, true, false));
        bNewCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog id = new InputDialog(PreferencesServer.this.getShell(), Messages.PreferencesServer_newDirectory, Messages.PreferencesServer_addNewDirectory, null, null);
                if (id.open() == 0) {
                    CategoryUtil.addCategory((String)id.getValue());
                    PreferencesServer.this.addCategory(id.getValue());
                    PreferencesServer.this.mainComposite.layout();
                }
            }
        });
        Button bEditCat = new Button(buttonComposite, 8);
        bEditCat.setImage(Images.IMG_EDIT.getImage());
        bEditCat.setToolTipText(Messages.PreferencesServer_renameDirectoryTooltip);
        bEditCat.setLayoutData((Object)new GridData(4, 128, true, false));
        bEditCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedCategory = PreferencesServer.this.lastSelectedCategory;
                if (selectedCategory.isEmpty()) {
                    return;
                }
                InputDialog id = new InputDialog(PreferencesServer.this.getShell(), MessageFormat.format(Messages.PreferencesServer_renameDirectory, selectedCategory), Messages.PreferencesServer_enterNewNameForDirectory, selectedCategory, null);
                if (id.open() == 0) {
                    CategoryUtil.renameCategory((String)selectedCategory, (String)id.getValue());
                    PreferencesServer.this.renameCategory(selectedCategory, id.getValue());
                }
            }
        });
        Button bDeleteCat = new Button(buttonComposite, 8);
        bDeleteCat.setImage(Images.IMG_DELETE.getImage());
        bDeleteCat.setToolTipText(Messages.PreferencesServer_deleteDirectory);
        bDeleteCat.setLayoutData((Object)new GridData(4, 128, true, false));
        bDeleteCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedCategory = PreferencesServer.this.lastSelectedCategory;
                if (selectedCategory.isEmpty()) {
                    return;
                }
                List documents = CategoryUtil.getDocumentsWithCategoryByName((String)selectedCategory);
                CategorySelectDialog catSelectDialog = new CategorySelectDialog(PreferencesServer.this.getShell(), MessageFormat.format(Messages.PreferencesServer_deleteCategory, selectedCategory), Messages.PreferencesServer_documentsInCategory, CategoryUtil.getCategoriesNames());
                if (catSelectDialog.open() == 0) {
                    String newCategory = catSelectDialog.getSelectedCategory();
                    for (IDocumentHandle document : documents) {
                        document.setCategory((ICategory)new TransientCategory(newCategory));
                    }
                    CategoryUtil.removeCategory((String)selectedCategory, (String)newCategory);
                    PreferencesServer.this.removeCategory(selectedCategory, newCategory);
                }
            }
        });
        Label patientSourceLabel = new Label(contentComposite, 0);
        patientSourceLabel.setText(Messages.PreferencesServer_patientSourceLabel);
        GridData patientSourceLabelGridData = new GridData(131072, 0x1000000, false, false);
        patientSourceLabelGridData.widthHint = labelWidth;
        patientSourceLabel.setLayoutData((Object)patientSourceLabelGridData);
        this.patientSourceCombo = new Combo(contentComposite, 12);
        GridData patientSourceComboGridData = new GridData(4, 0x1000000, true, false);
        this.patientSourceCombo.setLayoutData((Object)patientSourceComboGridData);
        this.patientSourceCombo.setItems(new String[]{Messages.PreferencesServer_patientSource_filePrefix, Messages.PreferencesServer_patientSource_folder, Messages.PreferencesServer_patientSource_hierarchy, Messages.PreferencesServer_patientSource_hybrid});
        this.loadDeviceData();
        this.updateDeviceCombo();
        this.updateDeviceFields();
        return this.mainComposite;
    }

    private void updateCategoriesListForDevice(String device) {
        List allCategories = CategoryUtil.getCategoriesNames();
        this.categoryListViewer.setInput((Object)allCategories);
        this.categoryListViewer.refresh();
        String selectedCategory = ConfigServiceHolder.getGlobal((String)("plugins/global_inbox_server/categories_" + device), (String)"");
        if (selectedCategory != null && !selectedCategory.isEmpty()) {
            this.categoryListViewer.setSelection((ISelection)new StructuredSelection((Object)selectedCategory));
            this.lastSelectedCategory = selectedCategory;
        } else {
            this.lastSelectedCategory = null;
        }
    }

    private void addCategory(String categoryName) {
        List<String> categories = this.getCategoriesForDevice(this.deviceCombo.getText());
        if (!categories.contains(categoryName)) {
            categories.add(categoryName);
            this.saveCategoriesForDevice(this.deviceCombo.getText(), categories);
        }
        this.updateCategoriesListForDevice(this.deviceCombo.getText());
    }

    private void renameCategory(String oldCategoryName, String newCategoryName) {
        List<String> categories = this.getCategoriesForDevice(this.deviceCombo.getText());
        int index = categories.indexOf(oldCategoryName);
        if (index != -1) {
            categories.set(index, newCategoryName);
            this.saveCategoriesForDevice(this.deviceCombo.getText(), categories);
        }
        this.lastSelectedCategory = newCategoryName;
        ConfigServiceHolder.get().set("plugins/global_inbox_server/last_selected_category", newCategoryName);
        this.updateCategoriesListForDevice(this.deviceCombo.getText());
    }

    private void removeCategory(String oldCategoryName, String newCategoryName) {
        List<String> categories = this.getCategoriesForDevice(this.deviceCombo.getText());
        categories.remove(oldCategoryName);
        this.saveCategoriesForDevice(this.deviceCombo.getText(), categories);
        this.updateCategoriesListForDevice(this.deviceCombo.getText());
    }

    private List<String> getCategoriesForDevice(String device) {
        String categoriesString = ConfigServiceHolder.getGlobal((String)("plugins/global_inbox_server/categories_" + device), (String)"");
        return StringUtils.isNotBlank((CharSequence)categoriesString) ? new ArrayList<String>(List.of(categoriesString.split(","))) : new ArrayList();
    }

    private void saveCategoriesForDevice(String device, List<String> categories) {
        String categoriesString = String.join((CharSequence)",", categories);
        ConfigServiceHolder.get().set("plugins/global_inbox_server/categories_" + device, categoriesString);
    }

    private String[][] getDeviceEntries() {
        String devices = ConfigServiceHolder.getGlobal((String)"plugins/global_inbox_server/devices", (String)"");
        if (StringUtils.isNotBlank((CharSequence)devices)) {
            String[] deviceArray = devices.split(",");
            String[][] deviceEntries = new String[deviceArray.length][2];
            int i = 0;
            while (i < deviceArray.length) {
                deviceEntries[i][0] = deviceArray[i];
                deviceEntries[i][1] = deviceArray[i];
                ++i;
            }
            return deviceEntries;
        }
        return new String[0][0];
    }

    private void deleteSelectedDevice(String selectedDevice, Composite mainComposite) {
        if (StringUtils.isNotBlank((CharSequence)selectedDevice)) {
            String devices = ConfigServiceHolder.getGlobal((String)"plugins/global_inbox_server/devices", (String)"");
            String[] deviceArray = devices.split(",");
            StringBuilder newDevices = new StringBuilder();
            String[] stringArray = deviceArray;
            int n = deviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                String device = stringArray[n2];
                if (!device.equals(selectedDevice)) {
                    if (newDevices.length() > 0) {
                        newDevices.append(",");
                    }
                    newDevices.append(device);
                }
                ++n2;
            }
            ConfigServiceHolder.get().set("plugins/global_inbox_server/devices", newDevices.toString());
            ConfigServiceHolder.get().set("plugins/global_inbox_server/device_dir_" + selectedDevice, "");
            ConfigServiceHolder.get().set("plugins/global_inbox_server/selectedDevice", "");
            ConfigServiceHolder.get().set("plugins/global_inbox_server/categories_" + selectedDevice, "");
            if (this.taskManagerHandler.getTaskDescriptorByReferenceId(selectedDevice) != null) {
                this.taskManagerHandler.deleteTaskDescriptorByReferenceId(selectedDevice);
            }
            this.updateDeviceCombo();
            if (selectedDevice.equals(this.lastSelectedCategory)) {
                this.lastSelectedCategory = "";
                ConfigServiceHolder.get().set("plugins/global_inbox_server/last_selected_category", "");
            }
        }
    }

    private void addNewDevice(String deviceName, Composite mainComposite) {
        if (StringUtils.isNotBlank((CharSequence)deviceName)) {
            Object devices = ConfigServiceHolder.getGlobal((String)"plugins/global_inbox_server/devices", (String)"");
            devices = StringUtils.isNotBlank((CharSequence)devices) ? (String)devices + "," + deviceName : deviceName;
            ConfigServiceHolder.get().set("plugins/global_inbox_server/devices", (String)devices);
            this.updateDeviceCombo();
        }
    }

    private void updateDeviceCombo() {
        String[][] deviceEntries;
        this.deviceCombo.removeAll();
        String[][] stringArray = deviceEntries = this.getDeviceEntries();
        int n = deviceEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String[] deviceEntry = stringArray[n2];
            this.deviceCombo.add(deviceEntry[0]);
            ++n2;
        }
        if (deviceEntries.length > 0) {
            this.deviceCombo.select(0);
        }
        this.updateDeviceFields();
    }

    private void updateDeviceFields() {
        String selectedDevice = this.deviceCombo.getText();
        if (StringUtils.isNotBlank((CharSequence)selectedDevice)) {
            String dir = ConfigServiceHolder.getGlobal((String)("plugins/global_inbox_server/device_dir_" + selectedDevice), (String)"");
            this.deviceDirText.setText(StringUtils.defaultString((String)dir));
            int strategyIndex = ConfigServiceHolder.getGlobal((String)("global_inbox/patient_strategy_" + selectedDevice), (int)0);
            if (strategyIndex >= 0 && strategyIndex < this.patientSourceCombo.getItemCount()) {
                this.patientSourceCombo.select(strategyIndex);
            } else {
                this.patientSourceCombo.select(0);
            }
            this.updateCategoriesListForDevice(selectedDevice);
        }
    }

    private void loadDeviceData() {
        String devices = ConfigServiceHolder.getGlobal((String)"plugins/global_inbox_server/devices", (String)"");
        if (StringUtils.isNotBlank((CharSequence)devices)) {
            String[] deviceArray;
            String[] stringArray = deviceArray = devices.split(",");
            int n = deviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                String device = stringArray[n2];
                String dir = ConfigServiceHolder.getGlobal((String)("plugins/global_inbox_server/device_dir_" + device), (String)"");
                if (StringUtils.isNotBlank((CharSequence)dir)) {
                    this.deviceDirMap.put(device, dir);
                }
                ++n2;
            }
        }
    }

    public boolean performOk() {
        String selectedDevice = this.deviceCombo.getText();
        if (StringUtils.isNotBlank((CharSequence)selectedDevice)) {
            String destinationDir = this.deviceDirText.getText();
            if (this.lastSelectedCategory == null) {
                this.lastSelectedCategory = "";
            }
            ConfigServiceHolder.get().set("plugins/global_inbox_server/device_dir_" + selectedDevice, this.deviceDirText.getText());
            ConfigServiceHolder.get().set("plugins/global_inbox_server/selectedDevice", selectedDevice);
            ConfigServiceHolder.get().set("plugins/global_inbox_server/categories_" + selectedDevice, this.lastSelectedCategory);
            int strategyIndex = this.patientSourceCombo.getSelectionIndex();
            ConfigServiceHolder.get().set("global_inbox/patient_strategy_" + selectedDevice, strategyIndex);
            if (StringUtils.isNotBlank((CharSequence)destinationDir)) {
                this.taskManagerHandler.createAndConfigureTask(selectedDevice, destinationDir);
            }
        }
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        ConfigServiceHolder.get().set("plugins/global_inbox_server/selectedDevice", "");
        String devices = ConfigServiceHolder.getGlobal((String)"plugins/global_inbox_server/devices", (String)"");
        if (StringUtils.isNotBlank((CharSequence)devices)) {
            String[] deviceArray;
            String[] stringArray = deviceArray = devices.split(",");
            int n = deviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                String device = stringArray[n2];
                ConfigServiceHolder.get().set("plugins/global_inbox_server/device_dir_" + device, "");
                ConfigServiceHolder.get().set("plugins/global_inbox_server/categories_" + device, "");
                ++n2;
            }
        }
        this.updateDeviceCombo();
        this.updateDeviceFields();
    }
}

