/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.internal.service;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IStoreToStringService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.global_inbox.model.GlobalInboxEntry;
import ch.elexis.global_inbox.ui.GlobalInboxUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={GlobalInboxEntryFactory.class}, immediate=true)
public class GlobalInboxEntryFactory {
    @Reference
    private IStoreToStringService storeToStringService;
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IConfigService configService;
    @Reference
    private IAccessControlService accessControl;
    private static List<Function> extensionFileHandlers = new ArrayList<Function>();

    @Activate
    public void activate() {
        this.accessControl.doPrivileged(() -> {
            File giDir;
            boolean created;
            String giDirSetting = GlobalInboxUtil.getDirectory("NOTSET", this.configService);
            if ("NOTSET".equals(giDirSetting) && (created = (giDir = new File(CoreHub.getWritableUserDir(), "GlobalInbox")).mkdir())) {
                ConfigServiceHolder.get().setLocal("plugins/global_inbox/dir", giDir.getAbsolutePath());
            }
        });
    }

    @Reference(target="(service.name=ch.elexis.global_inbox.extensionfilehandler)", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setExtensionFileHandler(Function extensionFileHandler) {
        extensionFileHandlers.add(extensionFileHandler);
    }

    public void unsetExtensionFileHandler(Function extensionFileHandler) {
        extensionFileHandlers.remove(extensionFileHandler);
    }

    public GlobalInboxEntry createEntry(File mainFile, File[] extensionFiles) {
        GlobalInboxEntry globalInboxEntry = new GlobalInboxEntry(mainFile, extensionFiles);
        String category = GlobalInboxUtil.getCategory(mainFile);
        String mimeType = null;
        try {
            mimeType = Files.probeContentType(mainFile.toPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (mimeType == null) {
            mimeType = FilenameUtils.getExtension((String)mainFile.getAbsolutePath());
        }
        globalInboxEntry.setMimetype(mimeType);
        globalInboxEntry.setCategory(category);
        globalInboxEntry.setSendInfoTo(this.configService.getLocal("plugins/global_inbox/infoToInbox", false));
        return globalInboxEntry;
    }

    public GlobalInboxEntry populateExtensionInformation(GlobalInboxEntry globalInboxEntry) {
        File[] extensionFiles;
        File[] fileArray = extensionFiles = globalInboxEntry.getExtensionFiles();
        int n = extensionFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String absolutePath = file.getAbsolutePath();
            for (Function handler : extensionFileHandlers) {
                Map result = (Map)handler.apply(absolutePath);
                if (result == null) continue;
                this.integrateAdditionalInformation(result, globalInboxEntry);
            }
            ++n2;
        }
        return globalInboxEntry;
    }

    private void integrateAdditionalInformation(Map<String, Object> result, GlobalInboxEntry gie) {
        List senderCandidatesSts;
        Object senderCandidates;
        List patientCandidatesSts;
        Object patientCandidates;
        Object object;
        List _dateTokens;
        Object dateTokens = result.get("dateTokens");
        if (dateTokens instanceof List && (_dateTokens = (List)dateTokens) != null && !_dateTokens.isEmpty()) {
            gie.setDateTokens(_dateTokens);
        }
        if ((object = result.get("creationDateCandidate")) instanceof LocalDate) {
            gie.setCreationDateCandidate((LocalDate)object);
        }
        if ((patientCandidates = result.get("patientCandidates")) instanceof List && (patientCandidatesSts = (List)patientCandidates) != null && !patientCandidatesSts.isEmpty()) {
            List _patients = patientCandidatesSts.stream().map(storeToString -> this.storeToStringService.loadFromString(storeToString).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
            List<IPatient> patients = _patients.stream().map(i -> this.modelService.load(i.getId(), IPatient.class).orElse(null)).collect(Collectors.toList());
            gie.setPatientCandidates(patients);
            if (patients.size() == 1) {
                gie.setPatient(patients.get(0));
            }
        }
        if ((senderCandidates = result.get("senderCandidates")) instanceof List && (senderCandidatesSts = (List)senderCandidates) != null && !senderCandidatesSts.isEmpty()) {
            List _senders = senderCandidatesSts.stream().map(storeToString -> this.storeToStringService.loadFromString(storeToString).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
            List<IContact> senders = _senders.stream().map(i -> this.modelService.load(i.getId(), IContact.class).orElse(null)).collect(Collectors.toList());
            gie.setSenderCandidates(senders);
            if (senders.size() == 1) {
                gie.setSender(senders.get(0));
            }
        }
    }
}

