/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.ui.parts;

import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IHistory;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IXid;
import ch.elexis.core.types.DocumentStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

class FileDocument
implements IDocument {
    private final File file;
    private final BasicFileAttributes attr;

    public static FileDocument of(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("must not be null");
        }
        BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        FileDocument fileDocument = new FileDocument(file, attr);
        return fileDocument;
    }

    private FileDocument(File file, BasicFileAttributes attr) {
        this.file = file;
        this.attr = attr;
    }

    public String getId() {
        return this.file.getName();
    }

    public String getLabel() {
        return this.file.getName();
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    public IXid getXid(String domain) {
        return null;
    }

    public Long getLastupdate() {
        return this.file.lastModified();
    }

    public boolean isDeleted() {
        return false;
    }

    public void setDeleted(boolean value) {
    }

    public String getTitle() {
        return this.file.getName();
    }

    public void setTitle(String value) {
    }

    public String getDescription() {
        return null;
    }

    public void setDescription(String value) {
    }

    public List<DocumentStatus> getStatus() {
        return null;
    }

    public Date getCreated() {
        long milliseconds = this.attr.creationTime().to(TimeUnit.MILLISECONDS);
        if (milliseconds > Long.MIN_VALUE && milliseconds < Long.MAX_VALUE) {
            Date creationDate = new Date(this.attr.creationTime().to(TimeUnit.MILLISECONDS));
            return creationDate;
        }
        return null;
    }

    public void setCreated(Date value) {
    }

    public Date getLastchanged() {
        long milliseconds = this.attr.lastModifiedTime().to(TimeUnit.MILLISECONDS);
        if (milliseconds > Long.MIN_VALUE && milliseconds < Long.MAX_VALUE) {
            Date lastModified = new Date(this.attr.lastModifiedTime().to(TimeUnit.MILLISECONDS));
            return lastModified;
        }
        return null;
    }

    public void setLastchanged(Date value) {
    }

    public String getMimeType() {
        return null;
    }

    public void setMimeType(String value) {
    }

    public ICategory getCategory() {
        return null;
    }

    public void setCategory(ICategory value) {
    }

    public List<IHistory> getHistory() {
        return null;
    }

    public String getStoreId() {
        return "filesystem";
    }

    public void setStoreId(String value) {
    }

    public String getExtension() {
        String _url = this.file.toURI().toString();
        int lastIndexOf = _url.lastIndexOf(46);
        if (lastIndexOf > -1) {
            return _url.substring(lastIndexOf + 1);
        }
        return "";
    }

    public void setExtension(String value) {
    }

    public String getKeywords() {
        return null;
    }

    public void setKeywords(String value) {
    }

    public IPatient getPatient() {
        return null;
    }

    public void setPatient(IPatient value) {
    }

    public IContact getAuthor() {
        return null;
    }

    public void setAuthor(IContact value) {
    }

    public InputStream getContent() {
        try {
            return new FileInputStream(this.file);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).warn("[{}] getContent()", (Object)this.file.getAbsolutePath(), (Object)e);
            return null;
        }
    }

    public void setContent(InputStream content) {
    }

    public void setStatus(DocumentStatus status, boolean active) {
    }

    public long getContentLength() {
        return this.file.length();
    }
}

